/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.metadata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.fediz.core.config.Claim;
import org.apache.cxf.fediz.core.config.FederationContext;
import org.apache.cxf.fediz.core.config.FederationProtocol;
import org.apache.cxf.fediz.core.config.Protocol;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.util.DOMUtils;
import org.apache.cxf.fediz.core.util.SignatureUtils;
import org.apache.ws.security.util.UUIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class MetadataWriter {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataWriter.class);
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private static final DocumentBuilderFactory DOC_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();

    public Document getMetaData(FederationContext config) throws ProcessingException {
        try {
            Object issuer;
            List<Claim> claims;
            FederationProtocol fedprotocol;
            ByteArrayOutputStream bout = new ByteArrayOutputStream(4096);
            OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)bout, "UTF-8");
            XMLStreamWriter writer = XML_OUTPUT_FACTORY.createXMLStreamWriter(streamWriter);
            Protocol protocol = config.getProtocol();
            writer.writeStartDocument("UTF-8", "1.0");
            String referenceID = "_" + UUIDGenerator.getUUID();
            writer.writeStartElement("md", "EntityDescriptor", "urn:oasis:names:tc:SAML:2.0:metadata");
            writer.writeAttribute("ID", referenceID);
            String audience = "_someID";
            String serviceURL = null;
            if (protocol instanceof FederationProtocol) {
                serviceURL = ((FederationProtocol)protocol).getApplicationServiceURL();
                List<String> audienceList = config.getAudienceUris();
                if (audienceList != null && audienceList.size() > 0 && !"".equals(audienceList.get(0))) {
                    audience = audienceList.get(0);
                }
            }
            if (serviceURL == null) {
                serviceURL = audience;
            }
            writer.writeAttribute("entityID", serviceURL);
            writer.writeNamespace("md", "urn:oasis:names:tc:SAML:2.0:metadata");
            writer.writeNamespace("fed", "http://docs.oasis-open.org/wsfed/federation/200706");
            writer.writeNamespace("wsa", "http://www.w3.org/2005/08/addressing");
            writer.writeNamespace("auth", "http://docs.oasis-open.org/wsfed/federation/200706");
            writer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            writer.writeStartElement("md", "RoleDescriptor", "urn:oasis:names:tc:SAML:2.0:metadata");
            writer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "fed:ApplicationServiceType");
            writer.writeAttribute("protocolSupportEnumeration", "http://docs.oasis-open.org/wsfed/federation/200706");
            writer.writeStartElement("fed", "ApplicationServiceEndpoint", "http://docs.oasis-open.org/wsfed/federation/200706");
            writer.writeStartElement("wsa", "EndpointReference", "http://www.w3.org/2005/08/addressing");
            writer.writeStartElement("wsa", "Address", "http://www.w3.org/2005/08/addressing");
            writer.writeCharacters(serviceURL);
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeStartElement("fed", "TargetScope", "http://docs.oasis-open.org/wsfed/federation/200706");
            writer.writeStartElement("wsa", "EndpointReference", "http://www.w3.org/2005/08/addressing");
            writer.writeStartElement("wsa", "Address", "http://www.w3.org/2005/08/addressing");
            if (protocol instanceof FederationProtocol) {
                fedprotocol = (FederationProtocol)protocol;
                Object realmObj = fedprotocol.getRealm();
                String realm = null;
                if (realmObj instanceof String) {
                    realm = (String)realmObj;
                } else if (realmObj instanceof CallbackHandler) {
                    // empty if block
                }
                if (realm != null && !"".equals(realm)) {
                    writer.writeCharacters(realm);
                }
            }
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            if (protocol instanceof FederationProtocol && (claims = (fedprotocol = (FederationProtocol)protocol).getClaimTypesRequested()) != null && claims.size() > 0) {
                writer.writeStartElement("fed", "ClaimTypesRequested", "http://docs.oasis-open.org/wsfed/federation/200706");
                for (Claim claim : claims) {
                    writer.writeStartElement("auth", "ClaimType", "http://docs.oasis-open.org/wsfed/federation/200706");
                    writer.writeAttribute("Uri", claim.getType());
                    if (claim.isOptional()) {
                        writer.writeAttribute("Optional", "true");
                    } else {
                        writer.writeAttribute("Optional", "false");
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeStartElement("fed", "PassiveRequestorEndpoint", "http://docs.oasis-open.org/wsfed/federation/200706");
            writer.writeStartElement("wsa", "EndpointReference", "http://www.w3.org/2005/08/addressing");
            writer.writeStartElement("wsa", "Address", "http://www.w3.org/2005/08/addressing");
            if (protocol instanceof FederationProtocol && (issuer = (fedprotocol = (FederationProtocol)protocol).getIssuer()) instanceof String && !"".equals(issuer)) {
                writer.writeCharacters((String)issuer);
            }
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
            ((Writer)streamWriter).flush();
            bout.flush();
            if (LOG.isDebugEnabled()) {
                String out = new String(bout.toByteArray());
                LOG.debug("***************** unsigned ****************");
                LOG.debug(out);
                LOG.debug("***************** unsigned ****************");
            }
            ByteArrayInputStream is = new ByteArrayInputStream(bout.toByteArray());
            boolean hasSigningKey = false;
            try {
                if (config.getSigningKey().getCrypto() != null) {
                    hasSigningKey = true;
                }
            }
            catch (Exception ex) {
                LOG.info("No signingKey element found in config: " + ex.getMessage());
            }
            if (hasSigningKey) {
                Document result = SignatureUtils.signMetaInfo(config.getSigningKey().getCrypto(), config.getSigningKey().getKeyAlias(), config.getSigningKey().getKeyPassword(), is, referenceID);
                if (result != null) {
                    return result;
                }
                throw new ProcessingException("Failed to sign the metadata document: result=null");
            }
            return DOMUtils.readXml(is);
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Error creating service metadata information ", (Throwable)e);
            throw new ProcessingException("Error creating service metadata information: " + e.getMessage());
        }
    }

    static {
        DOC_BUILDER_FACTORY.setNamespaceAware(true);
    }
}

