/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.config;

import java.util.ArrayList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.fediz.core.TokenValidator;
import org.apache.cxf.fediz.core.config.Claim;
import org.apache.cxf.fediz.core.config.Protocol;
import org.apache.cxf.fediz.core.config.jaxb.ArgumentType;
import org.apache.cxf.fediz.core.config.jaxb.CallbackType;
import org.apache.cxf.fediz.core.config.jaxb.ClaimType;
import org.apache.cxf.fediz.core.config.jaxb.ClaimTypesRequested;
import org.apache.cxf.fediz.core.config.jaxb.FederationProtocolType;
import org.apache.cxf.fediz.core.config.jaxb.ProtocolType;
import org.apache.cxf.fediz.core.saml.SAMLTokenValidator;
import org.apache.cxf.fediz.core.util.ClassLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationProtocol
extends Protocol {
    private static final Logger LOG = LoggerFactory.getLogger(FederationProtocol.class);
    private Object request;
    private Object authenticationType;
    private Object issuer;
    private Object homeRealm;
    private Object freshness;
    private Object signInQuery;
    private Object realm;
    private List<TokenValidator> validators = new ArrayList<TokenValidator>();
    private ClassLoader classloader;

    public FederationProtocol(ProtocolType protocolType) {
        super(protocolType);
        FederationProtocolType fp = (FederationProtocolType)protocolType;
        if (fp.getTokenValidators() != null && fp.getTokenValidators().getValidator() != null) {
            for (String validatorClassname : fp.getTokenValidators().getValidator()) {
                Object obj = null;
                try {
                    obj = this.classloader == null ? ClassLoaderUtils.loadClass(validatorClassname, this.getClass()).newInstance() : this.classloader.loadClass(validatorClassname).newInstance();
                }
                catch (Exception ex) {
                    LOG.error("Failed to instantiate TokenValidator implementation class: '" + validatorClassname + "'\n" + ex.getClass().getCanonicalName() + ": " + ex.getMessage());
                }
                if (obj instanceof TokenValidator) {
                    this.validators.add(obj);
                    continue;
                }
                if (obj == null) continue;
                LOG.error("Invalid TokenValidator implementation class: '" + validatorClassname + "'");
            }
        }
        SAMLTokenValidator validator = new SAMLTokenValidator();
        this.validators.add(this.validators.size(), validator);
    }

    protected FederationProtocolType getFederationProtocol() {
        return (FederationProtocolType)super.getProtocolType();
    }

    protected void setFederationProtocol(FederationProtocolType federationProtocol) {
        super.setProtocolType(federationProtocol);
    }

    @Override
    public int hashCode() {
        return this.getFederationProtocol().hashCode();
    }

    public Object getRealm() {
        if (this.realm != null) {
            return this.realm;
        }
        CallbackType cbt = this.getFederationProtocol().getRealm();
        this.realm = this.loadCallbackType(cbt, "Realm");
        return this.realm;
    }

    public void setRealm(Object value) {
        boolean isString = value instanceof String;
        boolean isCallbackHandler = value instanceof CallbackHandler;
        if (!isString && !isCallbackHandler) {
            LOG.error("Unsupported 'Realm' object");
            throw new IllegalArgumentException("Unsupported 'Realm' object. Type must be java.lang.String or javax.security.auth.callback.CallbackHandler.");
        }
        this.realm = value;
    }

    @Override
    public boolean equals(Object obj) {
        return this.getFederationProtocol().equals(obj);
    }

    public String getRoleDelimiter() {
        return this.getFederationProtocol().getRoleDelimiter();
    }

    public void setRoleDelimiter(String value) {
        this.getFederationProtocol().setRoleDelimiter(value);
    }

    public String getRoleURI() {
        return this.getFederationProtocol().getRoleURI();
    }

    public void setRoleURI(String value) {
        this.getFederationProtocol().setRoleURI(value);
    }

    public String getApplicationServiceURL() {
        return this.getFederationProtocol().getApplicationServiceURL();
    }

    public void setApplicationServiceURL(String value) {
        this.getFederationProtocol().setApplicationServiceURL(value);
    }

    public Object getAuthenticationType() {
        if (this.authenticationType != null) {
            return this.authenticationType;
        }
        CallbackType cbt = this.getFederationProtocol().getAuthenticationType();
        this.authenticationType = this.loadCallbackType(cbt, "AuthenticationType");
        return this.authenticationType;
    }

    public void setAuthenticationType(Object value) {
        boolean isString = value instanceof String;
        boolean isCallbackHandler = value instanceof CallbackHandler;
        if (!isString && !isCallbackHandler) {
            LOG.error("Unsupported 'AuthenticationType' object");
            throw new IllegalArgumentException("Unsupported 'AuthenticationType' object. Type must be java.lang.String or javax.security.auth.callback.CallbackHandler.");
        }
        this.authenticationType = value;
    }

    public Object getHomeRealm() {
        if (this.homeRealm != null) {
            return this.homeRealm;
        }
        CallbackType cbt = this.getFederationProtocol().getHomeRealm();
        this.homeRealm = this.loadCallbackType(cbt, "HomeRealm");
        return this.homeRealm;
    }

    public void setHomeRealm(Object value) {
        boolean isString = value instanceof String;
        boolean isCallbackHandler = value instanceof CallbackHandler;
        if (!isString && !isCallbackHandler) {
            LOG.error("Unsupported 'HomeRealm' object");
            throw new IllegalArgumentException("Unsupported 'HomeRealm' object. Type must be java.lang.String or javax.security.auth.callback.CallbackHandler.");
        }
        this.homeRealm = value;
    }

    public Object getIssuer() {
        if (this.issuer != null) {
            return this.issuer;
        }
        CallbackType cbt = this.getFederationProtocol().getIssuer();
        this.issuer = this.loadCallbackType(cbt, "Issuer");
        return this.issuer;
    }

    public void setIssuer(Object value) {
        boolean isString = value instanceof String;
        boolean isCallbackHandler = value instanceof CallbackHandler;
        if (!isString && !isCallbackHandler) {
            LOG.error("Unsupported 'Issuer' object");
            throw new IllegalArgumentException("Unsupported 'Issuer' object. Type must be java.lang.String or javax.security.auth.callback.CallbackHandler.");
        }
        this.issuer = value;
    }

    public Object getFreshness() {
        if (this.freshness != null) {
            return this.freshness;
        }
        CallbackType cbt = this.getFederationProtocol().getFreshness();
        this.freshness = this.loadCallbackType(cbt, "Freshness");
        return this.freshness;
    }

    public void setFreshness(Object value) {
        boolean isString = value instanceof String;
        boolean isCallbackHandler = value instanceof CallbackHandler;
        if (!isString && !isCallbackHandler) {
            LOG.error("Unsupported 'Freshness' object");
            throw new IllegalArgumentException("Unsupported 'Freshness' object. Type must be java.lang.String or javax.security.auth.callback.CallbackHandler.");
        }
        this.freshness = value;
    }

    public Object getSignInQuery() {
        if (this.signInQuery != null) {
            return this.signInQuery;
        }
        CallbackType cbt = this.getFederationProtocol().getSignInQuery();
        this.signInQuery = this.loadCallbackType(cbt, "SignInQuery");
        return this.signInQuery;
    }

    public void setSignInQuery(Object value) {
        boolean isString = value instanceof String;
        boolean isCallbackHandler = value instanceof CallbackHandler;
        if (!isString && !isCallbackHandler) {
            LOG.error("Unsupported 'SignInQuery' object");
            throw new IllegalArgumentException("Unsupported 'SignInQuery' object. Type must be java.lang.String or javax.security.auth.callback.CallbackHandler.");
        }
        this.signInQuery = value;
    }

    public Object getRequest() {
        if (this.request != null) {
            return this.request;
        }
        CallbackType cbt = this.getFederationProtocol().getRequest();
        this.request = this.loadCallbackType(cbt, "Request");
        return this.request;
    }

    public void setRequest(Object value) {
        boolean isString = value instanceof String;
        boolean isCallbackHandler = value instanceof CallbackHandler;
        if (!isString && !isCallbackHandler) {
            LOG.error("Unsupported 'Request' object");
            throw new IllegalArgumentException("Unsupported 'Request' object. Type must be java.lang.String or javax.security.auth.callback.CallbackHandler.");
        }
        this.request = value;
    }

    public String getReply() {
        return this.getFederationProtocol().getReply();
    }

    public void setReply(String value) {
        this.getFederationProtocol().setReply(value);
    }

    public List<Claim> getClaimTypesRequested() {
        ClaimTypesRequested claimsRequested = this.getFederationProtocol().getClaimTypesRequested();
        ArrayList<Claim> claims = new ArrayList<Claim>();
        for (ClaimType c : claimsRequested.getClaimType()) {
            claims.add(new Claim(c));
        }
        return claims;
    }

    public void setClaimTypesRequested(ClaimTypesRequested value) {
        this.getFederationProtocol().setClaimTypesRequested(value);
    }

    public List<TokenValidator> getTokenValidators() {
        return this.validators;
    }

    public String getVersion() {
        return this.getFederationProtocol().getVersion();
    }

    public void setVersion(String value) {
        this.getFederationProtocol().setVersion(value);
    }

    @Override
    public String toString() {
        return this.getFederationProtocol().toString();
    }

    public ClassLoader getClassloader() {
        return this.classloader;
    }

    public void setClassloader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    private Object loadCallbackType(CallbackType cbt, String name) {
        if (cbt == null) {
            return null;
        }
        if (cbt.getType() == null || cbt.getType().equals((Object)ArgumentType.STRING)) {
            return new String(cbt.getValue());
        }
        if (cbt.getType().equals((Object)ArgumentType.CLASS)) {
            try {
                if (this.classloader == null) {
                    return ClassLoaderUtils.loadClass(cbt.getValue(), this.getClass()).newInstance();
                }
                return this.classloader.loadClass(cbt.getValue()).newInstance();
            }
            catch (Exception e) {
                LOG.error("Failed to create instance of " + cbt.getValue(), (Throwable)e);
                throw new IllegalStateException("Failed to create instance of " + cbt.getValue());
            }
        }
        LOG.error("Only String and Class are supported for '" + name + "'");
        throw new IllegalStateException("Only String and Class are supported for '" + name + "'");
    }
}

