/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.cxf.fediz.core.Claim;
import org.w3c.dom.Element;

public class FederationResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String audience;
    private String username;
    private List<String> roles;
    private String issuer;
    private List<Claim> claims;
    private Element token;
    private String uniqueTokenId;
    private Date tokenCreated;
    private Date tokenExpires;

    public FederationResponse(String username, String issuer, List<String> roles, List<Claim> claims, String audience, Date created, Date expires, Element token, String uniqueTokenId) {
        this.username = username;
        this.issuer = issuer;
        this.roles = roles;
        this.claims = claims;
        this.audience = audience;
        this.tokenCreated = created;
        this.tokenExpires = expires;
        this.token = token;
        this.uniqueTokenId = uniqueTokenId;
    }

    public String getUniqueTokenId() {
        return this.uniqueTokenId;
    }

    public String getAudience() {
        return this.audience;
    }

    public String getUsername() {
        return this.username;
    }

    public List<String> getRoles() {
        if (this.roles == null) {
            return null;
        }
        return Collections.unmodifiableList(this.roles);
    }

    public String getIssuer() {
        return this.issuer;
    }

    public List<Claim> getClaims() {
        if (this.claims == null) {
            return null;
        }
        return Collections.unmodifiableList(this.claims);
    }

    public Date getTokenCreated() {
        return this.tokenCreated;
    }

    public Date getTokenExpires() {
        return this.tokenExpires;
    }

    public Element getToken() {
        return this.token;
    }
}

