/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.tomcat;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.authenticator.SavedRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.cxf.fediz.core.FederationProcessor;
import org.apache.cxf.fediz.core.FederationProcessorImpl;
import org.apache.cxf.fediz.core.FederationRequest;
import org.apache.cxf.fediz.core.FederationResponse;
import org.apache.cxf.fediz.core.config.FederationConfigurator;
import org.apache.cxf.fediz.core.config.FederationContext;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.tomcat.FederationPrincipalImpl;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.ws.security.util.DOM2Writer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class FederationAuthenticator
extends FormAuthenticator {
    public static final String FEDERATION_NOTE = "org.apache.cxf.fediz.tomcat.FEDERATION";
    public static final String SECURITY_TOKEN = "org.apache.fediz.SECURITY_TOKEN";
    protected static final String INFO = "org.apache.cxf.fediz.tomcat.WsFedAuthenticator/1.0";
    protected static final String TRUSTED_ISSUER = "org.apache.cxf.fediz.tomcat.TRUSTED_ISSUER";
    private static final Log LOG = LogFactory.getLog(FormAuthenticator.class);
    protected String configFile;
    protected boolean tokenExpirationValidation = true;
    private FederationConfigurator configurator;

    public FederationAuthenticator() {
        LOG.debug((Object)"WsFedAuthenticator()");
    }

    public String getInfo() {
        return INFO;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public boolean isTokenExpirationValidation() {
        return this.tokenExpirationValidation;
    }

    public void setTokenExpirationValidation(boolean tokenExpirationValidation) {
        this.tokenExpirationValidation = tokenExpirationValidation;
    }

    protected synchronized void startInternal() throws LifecycleException {
        try {
            String catalinaBase;
            File f = new File(this.getConfigFile());
            if (!f.exists() && (catalinaBase = System.getProperty("catalina.base")) != null && catalinaBase.length() > 0) {
                f = new File(catalinaBase.concat(File.separator + this.getConfigFile()));
            }
            this.configurator = new FederationConfigurator();
            this.configurator.loadConfig(f);
            LOG.debug((Object)("Fediz configuration read from " + f.getAbsolutePath()));
        }
        catch (JAXBException e) {
            throw new LifecycleException("Failed to load Fediz configuration", (Throwable)e);
        }
        super.startInternal();
    }

    protected synchronized void stopInternal() throws LifecycleException {
        List fedContextList;
        if (this.configurator != null && (fedContextList = this.configurator.getFederationContextList()) != null) {
            for (FederationContext fedContext : fedContextList) {
                try {
                    fedContext.close();
                }
                catch (IOException ex) {}
            }
        }
        super.stopInternal();
    }

    protected FederationContext getContextConfiguration(String contextName) {
        if (this.configurator == null) {
            throw new IllegalStateException("No Fediz configuration available");
        }
        FederationContext config = this.configurator.getFederationContext(contextName);
        if (config == null) {
            throw new IllegalStateException("No Fediz configuration for context :" + contextName);
        }
        String catalinaBase = System.getProperty("catalina.base");
        if (catalinaBase != null && catalinaBase.length() > 0) {
            config.setRelativePath(catalinaBase);
        }
        return config;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        LOG.debug((Object)"WsFedAuthenticator:invoke()");
        if (request.getRequestURL().indexOf("FederationMetadata/2007-06/FederationMetadata.xml") != -1) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"WS-Federation Metadata document requested");
            }
            response.setContentType("text/xml");
            PrintWriter out = response.getWriter();
            String contextName = request.getServletContext().getContextPath();
            if (contextName == null || contextName.isEmpty()) {
                contextName = "/";
            }
            FederationContext fedConfig = this.getContextConfiguration(contextName);
            FederationProcessorImpl wfProc = new FederationProcessorImpl();
            try {
                Document metadata = wfProc.getMetaData(fedConfig);
                out.write(DOM2Writer.nodeToString((Node)metadata));
                return;
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed to get metadata document: " + ex.getMessage()));
                response.sendError(500);
                return;
            }
        }
        super.invoke(request, response);
    }

    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        SavedRequest saved;
        String uri;
        ArrayList<String> roles;
        LOG.debug((Object)"authenticate invoked");
        Session session = null;
        Object principal = request.getUserPrincipal();
        if (principal != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Already authenticated '" + principal.getName() + "'"));
            }
            if ((session = request.getSessionInternal()) == null) {
                LOG.debug((Object)"Session should not be null after authentication");
            } else {
                FederationResponse wfRes = (FederationResponse)session.getNote(FEDERATION_NOTE);
                Date tokenExpires = wfRes.getTokenExpires();
                if (tokenExpires == null) {
                    LOG.debug((Object)"Token doesn't expire");
                    return true;
                }
                if (!this.tokenExpirationValidation) {
                    LOG.debug((Object)"Token expiration not validated.");
                    return true;
                }
                Date currentTime = new Date();
                if (currentTime.after(wfRes.getTokenExpires())) {
                    LOG.debug((Object)"Token already expired. Clean up and redirect");
                    session.removeNote(FEDERATION_NOTE);
                    session.removeNote("org.apache.catalina.authenticator.PRINCIPAL");
                    session.setPrincipal(null);
                    request.getSession().removeAttribute(SECURITY_TOKEN);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Save request in session '" + session.getIdInternal() + "'"));
                    }
                    try {
                        this.saveRequest(request, session);
                    }
                    catch (IOException ioe) {
                        LOG.debug((Object)"Request body too big to save during authentication");
                        response.sendError(403, sm.getString("authenticator.requestBodyTooBig"));
                        return false;
                    }
                    FederationProcessorImpl wfProc = new FederationProcessorImpl();
                    this.redirectToIssuer(request, response, (FederationProcessor)wfProc);
                    return false;
                }
            }
            return true;
        }
        if (this.matchRequest(request)) {
            session = request.getSessionInternal(true);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Restore request from session '" + session.getIdInternal() + "'"));
            }
            principal = (Principal)session.getNote("org.apache.catalina.authenticator.PRINCIPAL");
            this.register(request, response, (Principal)principal, "WSFED", null, null);
            if (this.restoreRequest(request, session)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Proceed to restored request");
                }
                return true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Restore of original request failed");
            }
            response.sendError(400);
            return false;
        }
        String requestURI = request.getDecodedRequestURI();
        String wa = request.getParameter("wa");
        if (wa == null) {
            session = request.getSessionInternal(true);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Save request in session '" + session.getIdInternal() + "'"));
            }
            try {
                this.saveRequest(request, session);
            }
            catch (IOException ioe) {
                LOG.debug((Object)"Request body too big to save during authentication");
                response.sendError(403, sm.getString("authenticator.requestBodyTooBig"));
                return false;
            }
            FederationProcessorImpl wfProc = new FederationProcessorImpl();
            this.redirectToIssuer(request, response, (FederationProcessor)wfProc);
            return false;
        }
        String wresult = request.getParameter("wresult");
        FederationResponse wfRes = null;
        if (wa.equals("wsignin1.0")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"SignIn request found");
                LOG.debug((Object)"SignIn action...");
            }
            if (wresult == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"SignIn request must contain wresult");
                }
                response.sendError(400);
                return false;
            }
            request.getResponse().sendAcknowledgement();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Process SignIn request");
                LOG.debug((Object)("wresult=\n" + wresult));
            }
            FederationRequest wfReq = new FederationRequest();
            wfReq.setWa(wa);
            wfReq.setWresult(wresult);
            Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
            wfReq.setCerts(certs);
            String contextName = request.getServletContext().getContextPath();
            if (contextName == null || contextName.isEmpty()) {
                contextName = "/";
            }
            FederationContext fedConfig = this.getContextConfiguration(contextName);
            FederationProcessorImpl wfProc = new FederationProcessorImpl();
            try {
                wfRes = wfProc.processRequest(wfReq, fedConfig);
            }
            catch (ProcessingException ex) {
                LOG.error((Object)("Federation processing failed: " + ex.getMessage()));
                response.sendError(401);
                return false;
            }
            if (wfRes.getAudience() != null) {
                List audienceURIs = fedConfig.getAudienceUris();
                boolean validAudience = false;
                for (String a : audienceURIs) {
                    if (!wfRes.getAudience().startsWith(a)) continue;
                    validAudience = true;
                    break;
                }
                if (!validAudience) {
                    LOG.warn((Object)("Token AudienceRestriction [" + wfRes.getAudience() + "] doesn't match with specified list of URIs."));
                    response.sendError(403);
                    return false;
                }
                if (LOG.isDebugEnabled() && request.getRequestURL().indexOf(wfRes.getAudience()) == -1) {
                    LOG.debug((Object)("Token AudienceRestriction doesn't match with request URL [" + wfRes.getAudience() + "]  [" + request.getRequestURL() + "]"));
                }
            }
            if ((roles = wfRes.getRoles()) == null || roles.size() == 0) {
                roles = new ArrayList<String>();
                roles.add(new String("Authenticated"));
            }
        } else {
            LOG.error((Object)("Not supported action found in parameter wa: " + wa));
            response.sendError(400);
            return false;
        }
        principal = new FederationPrincipalImpl(wfRes.getUsername(), roles, wfRes.getClaims(), wfRes.getToken());
        if (principal == null) {
            this.forwardToErrorPage(request, response, config);
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Authentication of '" + principal + "' was successful"));
        }
        if (session == null) {
            session = request.getSessionInternal(false);
        }
        if (session == null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)"User took so long to log on the session expired");
            }
            if (this.landingPage == null) {
                response.sendError(408, sm.getString("authenticator.sessionExpired"));
            } else {
                uri = request.getContextPath() + this.landingPage;
                saved = new SavedRequest();
                saved.setMethod("GET");
                saved.setRequestURI(uri);
                request.getSessionInternal(true).setNote("org.apache.catalina.authenticator.REQUEST", (Object)saved);
                response.sendRedirect(response.encodeRedirectURL(uri));
            }
            return false;
        }
        session.setNote("org.apache.catalina.authenticator.PRINCIPAL", principal);
        session.setNote(FEDERATION_NOTE, (Object)wfRes);
        request.getSession(true).setAttribute(SECURITY_TOKEN, (Object)wfRes.getToken());
        requestURI = this.savedRequestURL(session);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Redirecting to original '" + requestURI + "'"));
        }
        if (requestURI == null) {
            if (this.landingPage == null) {
                response.sendError(400, sm.getString("authenticator.formlogin"));
            } else {
                uri = request.getContextPath() + this.landingPage;
                saved = new SavedRequest();
                saved.setMethod("GET");
                saved.setRequestURI(uri);
                session.setNote("org.apache.catalina.authenticator.REQUEST", (Object)saved);
                response.sendRedirect(response.encodeRedirectURL(uri));
            }
        } else {
            response.sendRedirect(response.encodeRedirectURL(requestURI));
        }
        return false;
    }

    protected String getAuthMethod() {
        return "WSFED";
    }

    protected void redirectToIssuer(Request request, HttpServletResponse response, FederationProcessor processor) throws IOException {
        String contextName = request.getServletContext().getContextPath();
        if (contextName == null || contextName.isEmpty()) {
            contextName = "/";
        }
        FederationContext fedCtx = this.configurator.getFederationContext(contextName);
        String redirectURL = null;
        try {
            redirectURL = processor.createSignInRequest((HttpServletRequest)request, fedCtx);
            if (redirectURL != null) {
                response.sendRedirect(redirectURL);
            } else {
                LOG.warn((Object)"Failed to create SignInRequest.");
                response.sendError(500, "Failed to create SignInRequest.");
            }
        }
        catch (ProcessingException ex) {
            LOG.warn((Object)("Failed to create SignInRequest: " + ex.getMessage()));
            response.sendError(500, "Failed to create SignInRequest.");
        }
    }
}

