/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.spring.web;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.config.Protocol;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.processor.FedizProcessor;
import org.apache.cxf.fediz.core.processor.FedizProcessorFactory;
import org.apache.cxf.fediz.core.processor.FedizRequest;
import org.apache.cxf.fediz.core.processor.RedirectionResponse;
import org.apache.cxf.fediz.spring.FederationConfig;
import org.apache.cxf.fediz.spring.authentication.ExpiredTokenException;
import org.apache.cxf.fediz.spring.authentication.FederationAuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.context.SecurityContext;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.ui.AbstractProcessingFilter;
import org.springframework.security.ui.FilterChainOrder;

public class FederationAuthenticationFilter
extends AbstractProcessingFilter {
    private static final Logger LOG = LoggerFactory.getLogger(FederationAuthenticationFilter.class);
    private FederationConfig federationConfig;

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        boolean result = request.getRequestURI().contains(this.getFilterProcessesUrl());
        result |= this.isTokenExpired();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("requiresAuthentication = " + result));
        }
        return result;
    }

    private boolean isTokenExpired() {
        Authentication authentication;
        boolean detectExpiredTokens;
        SecurityContext context = SecurityContextHolder.getContext();
        boolean bl = detectExpiredTokens = this.federationConfig != null && this.federationConfig.getFedizContext().isDetectExpiredTokens();
        if (context != null && detectExpiredTokens && (authentication = context.getAuthentication()) instanceof FederationAuthenticationToken) {
            Date tokenExpires = ((FederationAuthenticationToken)authentication).getResponse().getTokenExpires();
            if (tokenExpires == null) {
                return false;
            }
            Date currentTime = new Date();
            if (currentTime.after(tokenExpires)) {
                return true;
            }
        }
        return false;
    }

    public int getOrder() {
        return FilterChainOrder.BASIC_PROCESSING_FILTER;
    }

    public Authentication attemptAuthentication(HttpServletRequest request) throws AuthenticationException {
        Authentication authentication;
        SecurityContext context = SecurityContextHolder.getContext();
        if (context != null && (authentication = context.getAuthentication()) instanceof FederationAuthenticationToken) {
            throw new ExpiredTokenException("Token is expired");
        }
        String wa = request.getParameter("wa");
        String responseToken = this.getResponseToken((ServletRequest)request);
        FedizRequest wfReq = new FedizRequest();
        wfReq.setAction(wa);
        wfReq.setResponseToken(responseToken);
        wfReq.setState(request.getParameter("RelayState"));
        wfReq.setRequest(request);
        Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        wfReq.setCerts(certs);
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken(null, (Object)wfReq);
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
        return this.getAuthenticationManager().authenticate((Authentication)authRequest);
    }

    public void onUnsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) {
        if (authException instanceof ExpiredTokenException) {
            String redirectUrl = null;
            try {
                FedizContext fedContext = this.federationConfig.getFedizContext();
                FedizProcessor wfProc = FedizProcessorFactory.newFedizProcessor((Protocol)fedContext.getProtocol());
                RedirectionResponse redirectionResponse = wfProc.createSignInRequest(request, fedContext);
                redirectUrl = redirectionResponse.getRedirectionURL();
                if (redirectUrl == null) {
                    LOG.warn("Failed to create SignInRequest. Redirect URL null");
                    throw new BadCredentialsException("Failed to create SignInRequest. Redirect URL null");
                }
                Map headers = redirectionResponse.getHeaders();
                if (!headers.isEmpty()) {
                    for (String headerName : headers.keySet()) {
                        response.addHeader(headerName, (String)headers.get(headerName));
                    }
                }
            }
            catch (ProcessingException ex) {
                LOG.warn("Failed to create SignInRequest", (Throwable)ex);
                throw new BadCredentialsException("Failed to create SignInRequest: " + ex.getMessage());
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Redirecting to IDP: " + redirectUrl);
            }
            try {
                response.sendRedirect(redirectUrl);
            }
            catch (IOException ex) {
                throw new BadCredentialsException(ex.getMessage(), (Throwable)ex);
            }
        }
        try {
            response.sendError(401);
        }
        catch (IOException e) {
            throw authException;
        }
    }

    private String getResponseToken(ServletRequest request) {
        if (request.getParameter("wresult") != null) {
            return request.getParameter("wresult");
        }
        if (request.getParameter("SAMLResponse") != null) {
            return request.getParameter("SAMLResponse");
        }
        return null;
    }

    public String getDefaultFilterProcessesUrl() {
        return "/j_spring_fediz_security_check";
    }

    public FederationConfig getFederationConfig() {
        return this.federationConfig;
    }

    public void setFederationConfig(FederationConfig fedConfig) {
        this.federationConfig = fedConfig;
    }
}

