/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.spring.web;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.config.Protocol;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.metadata.MetadataDocumentHandler;
import org.apache.cxf.fediz.core.processor.FedizProcessor;
import org.apache.cxf.fediz.core.processor.FedizProcessorFactory;
import org.apache.cxf.fediz.core.processor.RedirectionResponse;
import org.apache.cxf.fediz.spring.FederationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.AuthenticationException;
import org.springframework.security.ui.AuthenticationEntryPoint;
import org.springframework.util.Assert;

public class FederationAuthenticationEntryPoint
implements AuthenticationEntryPoint,
InitializingBean,
ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(FederationAuthenticationEntryPoint.class);
    private ApplicationContext appContext;
    private FederationConfig federationConfig;

    public FederationConfig getFederationConfig() {
        return this.federationConfig;
    }

    public void setFederationConfig(FederationConfig federationConfig) {
        this.federationConfig = federationConfig;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.appContext, (String)"ApplicationContext cannot be null.");
        Assert.notNull((Object)this.federationConfig, (String)"FederationConfig cannot be null.");
    }

    protected void preCommence(HttpServletRequest request, HttpServletResponse response) {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appContext = applicationContext;
    }

    public void commence(ServletRequest request, ServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        HttpServletRequest hrequest = (HttpServletRequest)request;
        HttpServletResponse hresponse = (HttpServletResponse)response;
        FedizContext fedContext = this.federationConfig.getFedizContext();
        LOG.debug("Federation context: {}", (Object)fedContext);
        MetadataDocumentHandler mdHandler = new MetadataDocumentHandler(fedContext);
        if (mdHandler.canHandleRequest(hrequest)) {
            mdHandler.handleRequest(hrequest, hresponse);
            return;
        }
        String redirectUrl = null;
        try {
            Map headers;
            FedizProcessor wfProc = FedizProcessorFactory.newFedizProcessor((Protocol)fedContext.getProtocol());
            RedirectionResponse redirectionResponse = wfProc.createSignInRequest(hrequest, fedContext);
            redirectUrl = redirectionResponse.getRedirectionURL();
            if (redirectUrl == null) {
                LOG.warn("Failed to create SignInRequest.");
                hresponse.sendError(500, "Failed to create SignInRequest.");
            }
            if (!(headers = redirectionResponse.getHeaders()).isEmpty()) {
                for (String headerName : headers.keySet()) {
                    hresponse.addHeader(headerName, (String)headers.get(headerName));
                }
            }
        }
        catch (ProcessingException ex) {
            System.err.println("Failed to create SignInRequest: " + ex.getMessage());
            LOG.warn("Failed to create SignInRequest: " + ex.getMessage());
            hresponse.sendError(500, "Failed to create SignInRequest.");
        }
        this.preCommence(hrequest, hresponse);
        if (LOG.isInfoEnabled()) {
            LOG.info("Redirecting to IDP: " + redirectUrl);
        }
        hresponse.sendRedirect(redirectUrl);
    }
}

