/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.spring.authentication;

import java.io.Serializable;
import java.util.Collection;
import org.apache.cxf.fediz.core.ClaimCollection;
import org.apache.cxf.fediz.core.FedizPrincipal;
import org.apache.cxf.fediz.core.processor.FedizResponse;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.providers.AbstractAuthenticationToken;
import org.springframework.security.userdetails.UserDetails;
import org.w3c.dom.Element;

public class FederationAuthenticationToken
extends AbstractAuthenticationToken
implements Serializable,
FedizPrincipal {
    private static final long serialVersionUID = 1L;
    private final Object credentials;
    private final Object principal;
    private final UserDetails userDetails;
    private final FedizResponse response;

    public FederationAuthenticationToken(Object principal, Object credentials, GrantedAuthority[] authorities, UserDetails userDetails, FedizResponse response) {
        super(authorities);
        if (principal == null || "".equals(principal) || credentials == null || "".equals(credentials) || authorities == null || userDetails == null || response == null) {
            throw new IllegalArgumentException("Cannot pass null or empty values to constructor");
        }
        this.principal = principal;
        this.credentials = credentials;
        this.userDetails = userDetails;
        this.response = response;
        this.setAuthenticated(true);
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public FedizResponse getResponse() {
        return this.response;
    }

    public UserDetails getUserDetails() {
        return this.userDetails;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" Response: ").append(this.response);
        sb.append(" Credentials: ").append(this.credentials);
        return sb.toString();
    }

    public ClaimCollection getClaims() {
        return new ClaimCollection((Collection)this.response.getClaims());
    }

    public Element getLoginToken() {
        return this.response.getToken();
    }
}

