/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.spring.authentication;

import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.config.Protocol;
import org.apache.cxf.fediz.core.processor.FedizProcessor;
import org.apache.cxf.fediz.core.processor.FedizProcessorFactory;
import org.apache.cxf.fediz.core.processor.FedizRequest;
import org.apache.cxf.fediz.core.processor.FedizResponse;
import org.apache.cxf.fediz.spring.FederationConfig;
import org.apache.cxf.fediz.spring.SpringFedizMessageSource;
import org.apache.cxf.fediz.spring.authentication.FederationAuthenticationToken;
import org.apache.cxf.fediz.spring.authentication.FederationResponseAuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.providers.AuthenticationProvider;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsChecker;
import org.springframework.security.userdetails.checker.AccountStatusUserDetailsChecker;
import org.springframework.util.Assert;

public class FederationAuthenticationProvider
implements AuthenticationProvider,
InitializingBean,
MessageSourceAware {
    private static final Logger LOG = LoggerFactory.getLogger(FederationAuthenticationProvider.class);
    protected MessageSourceAccessor messages = SpringFedizMessageSource.getAccessor();
    private AuthenticationUserDetailsService authenticationUserDetailsService;
    private FederationConfig federationConfig;
    private final UserDetailsChecker userDetailsChecker = new AccountStatusUserDetailsChecker();

    public AuthenticationUserDetailsService getAuthenticationUserDetailsService() {
        return this.authenticationUserDetailsService;
    }

    public void setAuthenticationUserDetailsService(AuthenticationUserDetailsService authenticationUserDetailsService) {
        this.authenticationUserDetailsService = authenticationUserDetailsService;
    }

    public FederationConfig getFederationConfig() {
        return this.federationConfig;
    }

    public void setFederationConfig(FederationConfig federationConfig) {
        this.federationConfig = federationConfig;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationUserDetailsService, (String)"An authenticationUserDetailsService must be set");
        Assert.notNull((Object)this.messages, (String)"A message source must be set");
        Assert.notNull((Object)this.federationConfig, (String)"FederationConfig cannot be null.");
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!this.supports(authentication.getClass())) {
            return null;
        }
        if (!(authentication instanceof UsernamePasswordAuthenticationToken)) {
            return null;
        }
        if (authentication.getCredentials() == null || "".equals(authentication.getCredentials())) {
            throw new BadCredentialsException(this.messages.getMessage("FederationAuthenticationProvider.noSignInRequest", "Failed to get SignIn request"));
        }
        FederationAuthenticationToken result = null;
        if (result == null) {
            result = this.authenticateNow(authentication);
            result.setDetails(authentication.getDetails());
        }
        return result;
    }

    private FederationAuthenticationToken authenticateNow(Authentication authentication) throws AuthenticationException {
        try {
            FedizRequest wfReq = (FedizRequest)authentication.getCredentials();
            FedizContext context = this.federationConfig.getFedizContext();
            FedizProcessor wfProc = FedizProcessorFactory.newFedizProcessor((Protocol)context.getProtocol());
            FedizResponse wfRes = wfProc.processRequest(wfReq, context);
            UserDetails userDetails = this.loadUserByFederationResponse(wfRes);
            this.userDetailsChecker.check(userDetails);
            return new FederationAuthenticationToken(userDetails, authentication.getCredentials(), userDetails.getAuthorities(), userDetails, wfRes);
        }
        catch (Exception e) {
            LOG.error("Failed to validate SignIn request", (Throwable)e);
            throw new BadCredentialsException(e.getMessage(), (Throwable)e);
        }
    }

    protected UserDetails loadUserByFederationResponse(FedizResponse response) {
        FederationResponseAuthenticationToken token = new FederationResponseAuthenticationToken(response);
        return this.authenticationUserDetailsService.loadUserDetails((Authentication)token);
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public boolean supports(Class authentication) {
        if (UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication)) {
            return true;
        }
        return FederationAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

