/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.saml;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.cxf.fediz.core.Claim;
import org.apache.cxf.fediz.core.ClaimCollection;
import org.apache.cxf.fediz.core.ClaimTypes;
import org.apache.cxf.fediz.core.TokenValidator;
import org.apache.cxf.fediz.core.TokenValidatorRequest;
import org.apache.cxf.fediz.core.TokenValidatorResponse;
import org.apache.cxf.fediz.core.config.CertificateValidationMethod;
import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.config.Protocol;
import org.apache.cxf.fediz.core.config.TrustManager;
import org.apache.cxf.fediz.core.config.TrustedIssuer;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.saml.FedizSignatureTrustValidator;
import org.apache.cxf.fediz.core.saml.SAMLUtil;
import org.apache.cxf.fediz.core.saml.SamlAssertionValidator;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.principal.SAMLTokenPrincipalImpl;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SAMLKeyInfoProcessor;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.saml.WSSSAMLKeyInfoProcessor;
import org.apache.wss4j.dom.validate.Credential;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.AudienceRestrictionCondition;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SAMLTokenValidator
implements TokenValidator {
    private static final Logger LOG = LoggerFactory.getLogger(SAMLTokenValidator.class);

    @Override
    public boolean canHandleTokenType(String tokenType) {
        return "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(tokenType) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType) || "urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType);
    }

    @Override
    public boolean canHandleToken(Element token) {
        String ns = token.getNamespaceURI();
        return "urn:oasis:names:tc:SAML:2.0:assertion".equals(ns) || "urn:oasis:names:tc:SAML:1.0:assertion".equals(ns);
    }

    @Override
    public TokenValidatorResponse validateAndProcessToken(TokenValidatorRequest request, FedizContext config) throws ProcessingException {
        Element token = request.getToken();
        try {
            RequestData requestData = new RequestData();
            WSSConfig wssConfig = WSSConfig.getNewInstance();
            requestData.setWssConfig(wssConfig);
            SamlAssertionWrapper assertion = new SamlAssertionWrapper(token);
            if (!assertion.isSigned()) {
                LOG.warn("Assertion is not signed");
                throw new ProcessingException(ProcessingException.TYPE.TOKEN_NO_SIGNATURE);
            }
            WSDocInfo docInfo = new WSDocInfo(token.getOwnerDocument());
            Signature sig = assertion.getSignature();
            KeyInfo keyInfo = sig.getKeyInfo();
            SAMLKeyInfo samlKeyInfo = org.apache.wss4j.common.saml.SAMLUtil.getCredentialFromKeyInfo((Element)keyInfo.getDOM(), (SAMLKeyInfoProcessor)new WSSSAMLKeyInfoProcessor(requestData, docInfo), (Crypto)requestData.getSigVerCrypto());
            assertion.verifySignature(samlKeyInfo);
            assertion.parseSubject((SAMLKeyInfoProcessor)new WSSSAMLKeyInfoProcessor(requestData, docInfo), requestData.getSigVerCrypto(), requestData.getCallbackHandler());
            Credential trustCredential = new Credential();
            trustCredential.setPublicKey(samlKeyInfo.getPublicKey());
            trustCredential.setCertificates(samlKeyInfo.getCerts());
            trustCredential.setSamlAssertion(assertion);
            SamlAssertionValidator trustValidator = new SamlAssertionValidator();
            trustValidator.setFutureTTL(config.getMaximumClockSkew().intValue());
            boolean trusted = false;
            String assertionIssuer = assertion.getIssuerString();
            List<TrustedIssuer> trustedIssuers = config.getTrustedIssuers();
            for (TrustedIssuer ti : trustedIssuers) {
                Pattern subjectConstraint = ti.getCompiledSubject();
                ArrayList<Pattern> subjectConstraints = new ArrayList<Pattern>(1);
                if (subjectConstraint != null) {
                    subjectConstraints.add(subjectConstraint);
                }
                if (ti.getCertificateValidationMethod().equals((Object)CertificateValidationMethod.CHAIN_TRUST)) {
                    trustValidator.setSubjectConstraints(subjectConstraints);
                    trustValidator.setSignatureTrustType(FedizSignatureTrustValidator.TrustType.CHAIN_TRUST_CONSTRAINTS);
                } else if (ti.getCertificateValidationMethod().equals((Object)CertificateValidationMethod.PEER_TRUST)) {
                    trustValidator.setSignatureTrustType(FedizSignatureTrustValidator.TrustType.PEER_TRUST);
                } else {
                    throw new IllegalStateException("Unsupported certificate validation method: " + (Object)((Object)ti.getCertificateValidationMethod()));
                }
                try {
                    for (TrustManager tm : config.getCertificateStores()) {
                        try {
                            requestData.setSigVerCrypto(tm.getCrypto());
                            trustValidator.validate(trustCredential, requestData);
                            trusted = true;
                            break;
                        }
                        catch (Exception ex) {
                            LOG.debug("Issuer '{}' not validated in keystore '{}'", (Object)ti.getName(), (Object)tm.getName());
                        }
                    }
                    if (!trusted) continue;
                    break;
                }
                catch (Exception ex) {
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info("Issuer '" + assertionIssuer + "' doesn't match trusted issuer '" + ti.getName() + "': " + ex.getMessage());
                }
            }
            if (!trusted) {
                if (!this.isConditionValid(assertion, config.getMaximumClockSkew().intValue())) {
                    LOG.warn("Security token expired");
                    throw new ProcessingException(ProcessingException.TYPE.TOKEN_EXPIRED);
                }
                LOG.warn("Issuer '" + assertionIssuer + "' not trusted");
                throw new ProcessingException(ProcessingException.TYPE.ISSUER_NOT_TRUSTED);
            }
            if (!SAMLUtil.checkHolderOfKey(assertion, request.getCerts())) {
                LOG.warn("Assertion fails holder-of-key requirements");
                throw new ProcessingException(ProcessingException.TYPE.ISSUER_NOT_TRUSTED);
            }
            String audience = null;
            List<Claim> claims = null;
            if (assertion.getSamlVersion().equals(SAMLVersion.VERSION_20)) {
                claims = this.parseClaimsInAssertion(assertion.getSaml2());
                audience = this.getAudienceRestriction(assertion.getSaml2());
            } else if (assertion.getSamlVersion().equals(SAMLVersion.VERSION_11)) {
                claims = this.parseClaimsInAssertion(assertion.getSaml1());
                audience = this.getAudienceRestriction(assertion.getSaml1());
            }
            List<String> roles = this.parseRoles(config, claims);
            SAMLTokenPrincipalImpl p = new SAMLTokenPrincipalImpl(assertion);
            TokenValidatorResponse response = new TokenValidatorResponse(assertion.getId(), p.getName(), assertionIssuer, roles, new ClaimCollection((Collection<? extends Claim>)claims), audience);
            response.setExpires(this.getExpires(assertion));
            response.setCreated(this.getCreated(assertion));
            return response;
        }
        catch (WSSecurityException ex) {
            LOG.error("Security token validation failed", (Throwable)ex);
            throw new ProcessingException(ProcessingException.TYPE.TOKEN_INVALID);
        }
    }

    protected List<String> parseRoles(FedizContext config, List<Claim> claims) {
        List<String> roles = null;
        Protocol protocol = config.getProtocol();
        if (protocol.getRoleURI() != null) {
            URI roleURI = URI.create(protocol.getRoleURI());
            String delim = protocol.getRoleDelimiter();
            for (Claim c : claims) {
                if (!roleURI.equals(c.getClaimType())) continue;
                Object oValue = c.getValue();
                if (oValue instanceof String && !"".equals((String)oValue)) {
                    roles = delim == null ? Collections.singletonList((String)oValue) : this.parseRoles((String)oValue, delim);
                } else if (oValue instanceof List && !((List)oValue).isEmpty()) {
                    List values = (List)oValue;
                    roles = Collections.unmodifiableList(values);
                } else if (!(oValue instanceof String) && !(oValue instanceof List)) {
                    LOG.error("Unsupported value type of Claim value");
                    throw new IllegalStateException("Unsupported value type of Claim value");
                }
                claims.remove(c);
                break;
            }
        }
        return roles;
    }

    protected List<Claim> parseClaimsInAssertion(Assertion assertion) {
        List attributeStatements = assertion.getAttributeStatements();
        if (attributeStatements == null || attributeStatements.isEmpty()) {
            LOG.debug("No attribute statements found");
            return Collections.emptyList();
        }
        ArrayList<Claim> collection = new ArrayList<Claim>();
        HashMap<String, Claim> claimsMap = new HashMap<String, Claim>();
        for (org.opensaml.saml.saml1.core.AttributeStatement statement : attributeStatements) {
            LOG.debug("parsing statement: {}", (Object)statement.getElementQName());
            List attributes = statement.getAttributes();
            for (org.opensaml.saml.saml1.core.Attribute attribute : attributes) {
                LOG.debug("parsing attribute: {}", (Object)attribute.getAttributeName());
                Claim c = new Claim();
                c.setIssuer(assertion.getIssuer());
                if (attribute.getAttributeNamespace() != null) {
                    URI attrName = URI.create(attribute.getAttributeName());
                    if (attrName.isAbsolute()) {
                        c.setClaimType(attrName);
                        if (attribute.getAttributeName().startsWith(attribute.getAttributeNamespace())) {
                            LOG.info("AttributeName fully qualified '" + attribute.getAttributeName() + "' but does match with AttributeNamespace '" + attribute.getAttributeNamespace() + "'");
                        } else {
                            LOG.warn("AttributeName fully qualified '" + attribute.getAttributeName() + "' but does NOT match with AttributeNamespace (ignored) '" + attribute.getAttributeNamespace() + "'");
                        }
                    } else if (attribute.getAttributeNamespace().endsWith("/")) {
                        c.setClaimType(URI.create(attribute.getAttributeNamespace() + attribute.getAttributeName()));
                    } else {
                        c.setClaimType(URI.create(attribute.getAttributeNamespace() + "/" + attribute.getAttributeName()));
                    }
                } else {
                    c.setClaimType(URI.create(attribute.getAttributeName()));
                }
                ArrayList<String> valueList = new ArrayList<String>();
                for (XMLObject attributeValue : attribute.getAttributeValues()) {
                    Element attributeValueElement = attributeValue.getDOM();
                    String value = attributeValueElement.getTextContent();
                    LOG.debug(" [{}]", (Object)value);
                    valueList.add(value);
                }
                this.mergeClaimToMap(claimsMap, c, valueList);
            }
        }
        collection.addAll(claimsMap.values());
        return collection;
    }

    protected List<Claim> parseClaimsInAssertion(org.opensaml.saml.saml2.core.Assertion assertion) {
        List attributeStatements = assertion.getAttributeStatements();
        if (attributeStatements == null || attributeStatements.isEmpty()) {
            LOG.debug("No attribute statements found");
            return Collections.emptyList();
        }
        ArrayList<Claim> collection = new ArrayList<Claim>();
        HashMap<String, Claim> claimsMap = new HashMap<String, Claim>();
        for (AttributeStatement statement : attributeStatements) {
            LOG.debug("parsing statement: {}", (Object)statement.getElementQName());
            List attributes = statement.getAttributes();
            for (Attribute attribute : attributes) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("parsing attribute: " + attribute.getName());
                }
                Claim c = new Claim();
                URI attrName = URI.create(attribute.getName());
                if (ClaimTypes.URI_BASE.toString().equals(attribute.getNameFormat()) && !attrName.isAbsolute()) {
                    c.setClaimType(URI.create(ClaimTypes.URI_BASE + "/" + attribute.getName()));
                } else {
                    c.setClaimType(URI.create(attribute.getName()));
                }
                c.setIssuer(assertion.getIssuer().getNameQualifier());
                ArrayList<String> valueList = new ArrayList<String>();
                for (XMLObject attributeValue : attribute.getAttributeValues()) {
                    Element attributeValueElement = attributeValue.getDOM();
                    String value = attributeValueElement.getTextContent();
                    LOG.debug(" [{}]", (Object)value);
                    valueList.add(value);
                }
                this.mergeClaimToMap(claimsMap, c, valueList);
            }
        }
        collection.addAll(claimsMap.values());
        return collection;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void mergeClaimToMap(Map<String, Claim> claimsMap, Claim c, List<String> valueList) {
        Claim t = claimsMap.get(c.getClaimType().toString());
        if (t != null) {
            Object oValue = t.getValue();
            if (oValue instanceof String) {
                ArrayList<String> values = new ArrayList<String>();
                values.add((String)oValue);
                values.addAll(valueList);
                t.setValue(values);
                return;
            }
            if (oValue instanceof List) {
                List values = (List)oValue;
                values.addAll(valueList);
                t.setValue(values);
                return;
            }
            LOG.error("Unsupported value type of Claim value");
            throw new IllegalStateException("Unsupported value type of Claim value");
        }
        if (valueList.size() == 1) {
            c.setValue(valueList.get(0));
        } else {
            c.setValue(valueList);
        }
        claimsMap.put(c.getClaimType().toString(), c);
    }

    protected List<String> parseRoles(String value, String delim) {
        ArrayList<String> roles = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(value, delim);
        while (st.hasMoreTokens()) {
            String role = st.nextToken();
            roles.add(role);
        }
        return roles;
    }

    protected String getAudienceRestriction(Assertion assertion) {
        String audience = null;
        try {
            audience = ((org.opensaml.saml.saml1.core.Audience)((AudienceRestrictionCondition)assertion.getConditions().getAudienceRestrictionConditions().get(0)).getAudiences().get(0)).getUri();
        }
        catch (Exception ex) {
            LOG.warn("Failed to read audience" + ex.getMessage());
        }
        return audience;
    }

    protected String getAudienceRestriction(org.opensaml.saml.saml2.core.Assertion assertion) {
        String audience = null;
        try {
            audience = ((Audience)((AudienceRestriction)assertion.getConditions().getAudienceRestrictions().get(0)).getAudiences().get(0)).getAudienceURI();
        }
        catch (Exception ex) {
            LOG.warn("Failed to read audience" + ex.getMessage());
        }
        return audience;
    }

    private Date getExpires(SamlAssertionWrapper assertion) {
        DateTime validTill = null;
        validTill = assertion.getSamlVersion().equals(SAMLVersion.VERSION_20) ? assertion.getSaml2().getConditions().getNotOnOrAfter() : assertion.getSaml1().getConditions().getNotOnOrAfter();
        if (validTill == null) {
            return null;
        }
        return validTill.toDate();
    }

    private Date getCreated(SamlAssertionWrapper assertion) {
        DateTime validFrom = null;
        validFrom = assertion.getSamlVersion().equals(SAMLVersion.VERSION_20) ? assertion.getSaml2().getConditions().getNotBefore() : assertion.getSaml1().getConditions().getNotBefore();
        if (validFrom == null) {
            return null;
        }
        return validFrom.toDate();
    }

    protected boolean isConditionValid(SamlAssertionWrapper assertion, int maxClockSkew) throws WSSecurityException {
        DateTime validFrom = null;
        DateTime validTill = null;
        if (assertion.getSamlVersion().equals(SAMLVersion.VERSION_20) && assertion.getSaml2().getConditions() != null) {
            validFrom = assertion.getSaml2().getConditions().getNotBefore();
            validTill = assertion.getSaml2().getConditions().getNotOnOrAfter();
        } else if (assertion.getSamlVersion().equals(SAMLVersion.VERSION_11) && assertion.getSaml1().getConditions() != null) {
            validFrom = assertion.getSaml1().getConditions().getNotBefore();
            validTill = assertion.getSaml1().getConditions().getNotOnOrAfter();
        }
        if (validFrom != null) {
            DateTime currentTime = new DateTime();
            if (validFrom.isAfter((ReadableInstant)(currentTime = currentTime.plusSeconds(maxClockSkew)))) {
                LOG.debug("SAML Token condition (Not Before) not met");
                return false;
            }
        }
        if (validTill != null && validTill.isBeforeNow()) {
            LOG.debug("SAML Token condition (Not On Or After) not met");
            return false;
        }
        return true;
    }
}

