/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.handler;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.handler.RequestHandler;
import org.apache.cxf.fediz.core.processor.FedizProcessor;
import org.apache.cxf.fediz.core.processor.FedizProcessorFactory;
import org.apache.cxf.fediz.core.processor.RedirectionResponse;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class LogoutHandler
implements RequestHandler<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(LogoutHandler.class);
    protected final FedizContext fedizConfig;
    private final String servletContextPath;
    private Element token;

    public LogoutHandler(FedizContext fedConfig) {
        this(fedConfig, "/");
    }

    public LogoutHandler(FedizContext fedConfig, String servletContextPath) {
        this.fedizConfig = fedConfig;
        this.servletContextPath = servletContextPath;
    }

    @Override
    public boolean canHandleRequest(HttpServletRequest request) {
        String wa = request.getParameter("wa");
        if ("wsignout1.0".equals(wa) || "wsignoutcleanup1.0".equals(wa)) {
            return true;
        }
        String logoutUrl = this.fedizConfig.getLogoutURL();
        return logoutUrl != null && !logoutUrl.isEmpty() && this.servletContextPath != null && request.getRequestURI().equals(this.servletContextPath + logoutUrl);
    }

    @Override
    public Boolean handleRequest(HttpServletRequest request, HttpServletResponse response) {
        String wa = request.getParameter("wa");
        if ("wsignout1.0".equals(wa)) {
            return this.signout(request, response);
        }
        if ("wsignoutcleanup1.0".equals(wa)) {
            return this.signoutCleanup(request, response);
        }
        return this.customLogout(request, response);
    }

    protected boolean customLogout(HttpServletRequest request, HttpServletResponse response) {
        LOG.info("Custom Logout URL was invoked.");
        return this.signout(request, response);
    }

    protected boolean signoutCleanup(HttpServletRequest request, HttpServletResponse response) {
        LOG.info("SignOutCleanup request found. Terminating user session.");
        request.getSession().invalidate();
        String wreply = request.getParameter("wreply");
        if (wreply != null && !wreply.isEmpty()) {
            try {
                LOG.debug("Redirecting user after logout to: {}", (Object)wreply);
                response.sendRedirect(wreply);
            }
            catch (IOException e) {
                LOG.error("Error redirecting user after logout: {}", (Object)e.getMessage());
            }
        } else {
            LOG.debug("No wreply parameter was set in logout action. Returning logout image");
            this.writeLogoutImage(response);
        }
        return true;
    }

    public void setToken(Element token) {
        this.token = token;
    }

    protected boolean signout(HttpServletRequest request, HttpServletResponse response) {
        LOG.debug("SignOut request found. Redirecting to IDP...");
        try {
            FedizProcessor wfProc;
            RedirectionResponse redirectionResponse;
            String redirectURL;
            SamlAssertionWrapper assertionToken = null;
            if (this.token != null) {
                assertionToken = new SamlAssertionWrapper(this.token);
            }
            if ((redirectURL = (redirectionResponse = (wfProc = FedizProcessorFactory.newFedizProcessor(this.fedizConfig.getProtocol())).createSignOutRequest(request, assertionToken, this.fedizConfig)).getRedirectionURL()) != null) {
                Map<String, String> headers = redirectionResponse.getHeaders();
                if (!headers.isEmpty()) {
                    for (String headerName : headers.keySet()) {
                        response.addHeader(headerName, headers.get(headerName));
                    }
                }
                response.sendRedirect(redirectURL);
                return true;
            }
            LOG.warn("Failed to create SignOutRequest.");
        }
        catch (Exception ex) {
            LOG.warn("Failed to create SignOutRequest: " + ex.getMessage());
            try {
                response.sendError(500, "Failed to create SignOutRequest.");
            }
            catch (IOException e) {
                LOG.error("Failed to send error response: {}", (Object)e.getMessage());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeLogoutImage(HttpServletResponse response) {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("logout.jpg");
        if (inputStream == null) {
            LOG.warn("Could not write logout.jpg");
            return;
        }
        int read = 0;
        byte[] buf = new byte[1024];
        try {
            response.setContentType("image/jpeg");
            ServletOutputStream responseOutputStream = response.getOutputStream();
            while ((read = inputStream.read(buf)) != -1) {
                responseOutputStream.write(buf, 0, read);
            }
            responseOutputStream.flush();
        }
        catch (IOException e) {
            LOG.error("Could  not send logout image: {}", (Object)e.getMessage());
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

