/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.fediz.core.FedizConstants;

public final class FederationConstants
extends FedizConstants {
    public static final String WSFED_METHOD = "WSFED";
    public static final String PARAM_ACTION = "wa";
    public static final String ACTION_SIGNIN = "wsignin1.0";
    public static final String ACTION_SIGNOUT = "wsignout1.0";
    public static final String ACTION_SIGNOUT_CLEANUP = "wsignoutcleanup1.0";
    public static final String PARAM_REPLY = "wreply";
    public static final String PARAM_TREALM = "wtrealm";
    public static final String PARAM_FRESHNESS = "wfresh";
    public static final String PARAM_AUTH_TYPE = "wauth";
    public static final String PARAM_REQUEST = "wreq";
    public static final String PARAM_CURRENT_TIME = "wct";
    public static final String PARAM_CONTEXT = "wctx";
    public static final String PARAM_POLICY = "wp";
    public static final String PARAM_FED_CONTEXT = "wfed";
    public static final String PARAM_ENCODING = "wencoding";
    public static final String PARAM_RESULT = "wresult";
    public static final String PARAM_HOME_REALM = "whr";
    public static final String PARAM_REQUEST_PTR = "wreqptr";
    public static final String PARAM_RESULT_PTR = "wresultptr";
    public static final Map<String, URI> AUTH_TYPE_MAP;
    public static final URI AUTH_TYPE_UNKNOWN;
    public static final URI AUTH_TYPE_DEFAULT;
    public static final URI AUTH_TYPE_SSL;
    public static final URI AUTH_TYPE_SSL_AND_KEY;
    public static final URI AUTH_TYPE_SSL_STRONG_PASSWORD;
    public static final URI AUTH_TYPE_SSL_STRONG_PASSWORD_EXPIRATION;
    public static final URI AUTH_TYPE_SMARTCARD;
    public static final String METADATA_PATH_URI = "FederationMetadata/2007-06/FederationMetadata.xml";

    private FederationConstants() {
    }

    static {
        HashMap<String, URI> aMap = new HashMap<String, URI>();
        aMap.put("UNKNOWN", AUTH_TYPE_UNKNOWN);
        aMap.put("DEFAULT", AUTH_TYPE_DEFAULT);
        aMap.put("SSL", AUTH_TYPE_SSL);
        aMap.put("SSL_AND_KEY", AUTH_TYPE_SSL_AND_KEY);
        aMap.put("SSL_STRONG_PASSWORD", AUTH_TYPE_SSL_STRONG_PASSWORD);
        aMap.put("SSL_STRONG_PASSWORD_EXPIRATION", AUTH_TYPE_SSL_STRONG_PASSWORD_EXPIRATION);
        aMap.put("SMARTCARD", AUTH_TYPE_SMARTCARD);
        AUTH_TYPE_MAP = Collections.unmodifiableMap(aMap);
        AUTH_TYPE_UNKNOWN = URI.create("http://docs.oasis-open.org/wsfed/authorization/200706/authntypes/unknown");
        AUTH_TYPE_DEFAULT = URI.create("http://docs.oasis-open.org/wsfed/authorization/200706/authntypes/default");
        AUTH_TYPE_SSL = URI.create("http://docs.oasis-open.org/wsfed/authorization/200706/authntypes/Ssl");
        AUTH_TYPE_SSL_AND_KEY = URI.create("http://docs.oasis-open.org/wsfed/authorization/200706/authntypes/SslAndKey");
        AUTH_TYPE_SSL_STRONG_PASSWORD = URI.create("http://docs.oasis-open.org/wsfed/authorization/200706/authntypes/SslAndStrongPasssword");
        AUTH_TYPE_SSL_STRONG_PASSWORD_EXPIRATION = URI.create("http://docs.oasis-open.org/wsfed/authorization/200706/authntypes/SslAndStrongPasswordWithExpiration");
        AUTH_TYPE_SMARTCARD = URI.create("http://docs.oasis-open.org/wsfed/authorization/200706/authntypes/smartcard");
    }
}

