/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.spring.web;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.fediz.core.FederationRequest;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.ui.AbstractProcessingFilter;
import org.springframework.security.ui.FilterChainOrder;

public class FederationAuthenticationFilter
extends AbstractProcessingFilter {
    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        boolean result = request.getRequestURI().contains(this.getFilterProcessesUrl());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("requiresAuthentication = " + result));
        }
        return result;
    }

    public int getOrder() {
        return FilterChainOrder.BASIC_PROCESSING_FILTER;
    }

    public Authentication attemptAuthentication(HttpServletRequest request) throws AuthenticationException {
        String wa = request.getParameter("wa");
        String wresult = request.getParameter("wresult");
        FederationRequest wfReq = new FederationRequest();
        wfReq.setWa(wa);
        wfReq.setWresult(wresult);
        Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        wfReq.setCerts(certs);
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken(null, (Object)wfReq);
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
        return this.getAuthenticationManager().authenticate((Authentication)authRequest);
    }

    public String getDefaultFilterProcessesUrl() {
        return "/j_spring_fediz_security_check";
    }
}

