/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.spring.web;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.fediz.core.FederationProcessorImpl;
import org.apache.cxf.fediz.core.config.FederationContext;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.spring.FederationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.AuthenticationException;
import org.springframework.security.ui.AuthenticationEntryPoint;
import org.springframework.util.Assert;

public class FederationAuthenticationEntryPoint
implements AuthenticationEntryPoint,
InitializingBean,
ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(FederationAuthenticationEntryPoint.class);
    private ApplicationContext appContext;
    private FederationConfig federationConfig;

    public FederationConfig getFederationConfig() {
        return this.federationConfig;
    }

    public void setFederationConfig(FederationConfig federationConfig) {
        this.federationConfig = federationConfig;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.appContext, (String)"ApplicationContext cannot be null.");
        Assert.notNull((Object)this.federationConfig, (String)"FederationConfig cannot be null.");
    }

    public final void commence(HttpServletRequest servletRequest, HttpServletResponse response, AuthenticationException authenticationException) throws IOException, ServletException {
        String redirectUrl = null;
        FederationContext fedContext = this.federationConfig.getFederationContext();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Federation context: " + fedContext);
        }
        try {
            FederationProcessorImpl wfProc = new FederationProcessorImpl();
            redirectUrl = wfProc.createSignInRequest(servletRequest, fedContext);
            if (redirectUrl == null) {
                LOG.warn("Failed to create SignInRequest. Redirect URL null");
                throw new ServletException("Failed to create SignInRequest. Redirect URL null");
            }
        }
        catch (ProcessingException ex) {
            LOG.warn("Failed to create SignInRequest", (Throwable)ex);
            throw new ServletException("Failed to create SignInRequest: " + ex.getMessage());
        }
        this.preCommence(servletRequest, response);
        if (LOG.isInfoEnabled()) {
            LOG.info("Redirecting to IDP: " + redirectUrl);
        }
        response.sendRedirect(redirectUrl);
    }

    protected void preCommence(HttpServletRequest request, HttpServletResponse response) {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appContext = applicationContext;
    }

    public void commence(ServletRequest request, ServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        HttpServletRequest hrequest = (HttpServletRequest)request;
        HttpServletResponse hresponse = (HttpServletResponse)response;
        String redirectUrl = null;
        FederationContext fedContext = this.federationConfig.getFederationContext();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Federation context: " + fedContext);
        }
        try {
            FederationProcessorImpl wfProc = new FederationProcessorImpl();
            redirectUrl = wfProc.createSignInRequest(hrequest, fedContext);
            if (redirectUrl == null) {
                LOG.warn("Failed to create SignInRequest.");
                hresponse.sendError(500, "Failed to create SignInRequest.");
            }
        }
        catch (ProcessingException ex) {
            System.err.println("Failed to create SignInRequest: " + ex.getMessage());
            LOG.warn("Failed to create SignInRequest: " + ex.getMessage());
            hresponse.sendError(500, "Failed to create SignInRequest.");
        }
        this.preCommence(hrequest, hresponse);
        if (LOG.isInfoEnabled()) {
            LOG.info("Redirecting to IDP: " + redirectUrl);
        }
        hresponse.sendRedirect(redirectUrl);
    }
}

