/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.spring.preauth;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.fediz.core.FederationPrincipal;
import org.springframework.security.ui.FilterChainOrder;
import org.springframework.security.ui.preauth.AbstractPreAuthenticatedProcessingFilter;

public class FederationPreAuthenticatedProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    private static final String SECURITY_TOKEN_ATTR = "org.apache.fediz.SECURITY_TOKEN";

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest httpRequest) {
        Principal principal = httpRequest.getUserPrincipal();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PreAuthenticated J2EE principal: " + httpRequest.getUserPrincipal() == null ? null : httpRequest.getUserPrincipal().getName());
        }
        return principal;
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest httpRequest) {
        Principal principal;
        Principal principal2 = principal = httpRequest.getUserPrincipal() == null ? null : httpRequest.getUserPrincipal();
        if (principal instanceof FederationPrincipal) {
            Object obj = httpRequest.getSession(false).getAttribute(SECURITY_TOKEN_ATTR);
            if (obj != null) {
                return obj;
            }
            this.logger.error((Object)"Session must contain Federation response");
            throw new IllegalStateException("Session must contain Federation response");
        }
        this.logger.error((Object)("Principal must be instance of FederationPrincipal: " + ((Object)principal).toString()));
        throw new IllegalStateException("Principal must be instance of FederationPrincipal");
    }

    public int getOrder() {
        return FilterChainOrder.BASIC_PROCESSING_FILTER;
    }
}

