/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.spring;

import java.util.List;
import org.apache.cxf.fediz.core.config.FederationConfigurator;
import org.apache.cxf.fediz.core.config.FederationContext;
import org.apache.cxf.fediz.spring.FederationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class FederationConfigImpl
implements FederationConfig {
    private static final Logger LOG = LoggerFactory.getLogger(FederationConfigImpl.class);
    private Resource configFile;
    private String contextName;
    private FederationConfigurator configurator = new FederationConfigurator();

    public Resource getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(Resource configFile) {
        this.configFile = configFile;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public void init() {
        Assert.notNull((Object)this.configFile, (String)"property 'configFile' mandatory");
        try {
            this.configurator.loadConfig(this.configFile.getFile());
        }
        catch (Exception e) {
            LOG.error("Failed to parse '" + this.configFile.getDescription() + "'", (Throwable)e);
            throw new BeanCreationException("Failed to parse '" + this.configFile.getDescription() + "'");
        }
    }

    @Override
    public List<FederationContext> getFederationContextList() {
        return this.configurator.getFederationContextList();
    }

    @Override
    public FederationContext getFederationContext(String context) {
        FederationContext ctx = this.configurator.getFederationContext(context);
        if (ctx == null) {
            LOG.error("Federation context '" + context + "' not found.");
            throw new IllegalStateException("Federation context '" + context + "' not found.");
        }
        return ctx;
    }

    @Override
    public FederationContext getFederationContext() {
        if (this.contextName != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reading federation configuration for context '" + this.contextName + "'");
            }
            return this.getFederationContext(this.contextName);
        }
        Assert.notNull((Object)this.contextName, (String)"Property 'contextName' must be configured because ServletContext null");
        return this.getFederationContext(this.contextName);
    }
}

