/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.oidc.logout;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.fediz.service.oidc.FedizSubjectCreator;
import org.apache.cxf.fediz.service.oidc.logout.BackChannelLogoutHandler;
import org.apache.cxf.fediz.service.oidc.logout.LogoutHandler;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.jose.common.JoseException;
import org.apache.cxf.rs.security.jose.jwt.JoseJwtConsumer;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oidc.common.IdToken;
import org.apache.cxf.rs.security.oidc.idp.OidcUserSubject;

@Path(value="/logout")
public class LogoutService
extends JoseJwtConsumer {
    private static final String CLIENT_LOGOUT_URI = "post_logout_redirect_uri";
    private static final String CLIENT_LOGOUT_URIS = "post_logout_redirect_uris";
    private static final String ID_TOKEN_HINT = "id_token_hint";
    @Context
    private MessageContext mc;
    private String relativeIdpLogoutUri;
    private OAuthDataProvider dataProvider;
    private FedizSubjectCreator subjectCreator = new FedizSubjectCreator();
    private BackChannelLogoutHandler backChannelLogoutHandler;
    private List<LogoutHandler> logoutHandlers;
    private boolean allowAnonymousLogout;

    @POST
    public Response initiateLogoutPost(MultivaluedMap<String, String> params) {
        return this.doInitiateLogout(params);
    }

    @GET
    public Response initiateLogoutGet() {
        return this.doInitiateLogout((MultivaluedMap<String, String>)this.mc.getUriInfo().getQueryParameters());
    }

    protected Response doInitiateLogout(MultivaluedMap<String, String> params) {
        IdToken idTokenHint = this.getIdTokenHint(params);
        Client client = this.getClient(params, idTokenHint);
        if (!this.allowAnonymousLogout || this.mc.getSecurityContext().getUserPrincipal() != null) {
            OidcUserSubject subject = this.subjectCreator.createUserSubject(this.mc, params);
            if (this.backChannelLogoutHandler != null) {
                this.backChannelLogoutHandler.handleLogout(client, subject, idTokenHint);
            }
            if (this.logoutHandlers != null) {
                for (LogoutHandler handler : this.logoutHandlers) {
                    handler.handleLogout(client, (UserSubject)subject);
                }
            }
        }
        this.mc.getHttpServletRequest().getSession().invalidate();
        URI idpLogoutUri = this.getAbsoluteIdpLogoutUri(client, params);
        return Response.seeOther((URI)idpLogoutUri).build();
    }

    private IdToken getIdTokenHint(MultivaluedMap<String, String> params) {
        String tokenHint = (String)params.getFirst((Object)ID_TOKEN_HINT);
        if (tokenHint == null) {
            return null;
        }
        JwtToken token = null;
        try {
            token = super.getJwtToken(tokenHint);
        }
        catch (JoseException ex) {
            throw new BadRequestException((Throwable)ex);
        }
        return new IdToken(token.getClaims());
    }

    private static URI getClientLogoutUri(Client client, MultivaluedMap<String, String> params) {
        String uriStr;
        String logoutUriProp = (String)client.getProperties().get(CLIENT_LOGOUT_URIS);
        String[] uris = logoutUriProp.split(" ");
        String clientLogoutUriParam = (String)params.getFirst((Object)CLIENT_LOGOUT_URI);
        if (uris.length > 1) {
            if (clientLogoutUriParam == null || !new HashSet<String>(Arrays.asList(uris)).contains(clientLogoutUriParam)) {
                throw new BadRequestException();
            }
            uriStr = clientLogoutUriParam;
        } else {
            if (clientLogoutUriParam != null && !uris[0].equals(clientLogoutUriParam)) {
                throw new BadRequestException();
            }
            uriStr = uris[0];
        }
        UriBuilder ub = UriBuilder.fromUri((String)uriStr);
        String state = (String)params.getFirst((Object)"state");
        if (state != null) {
            ub.queryParam("state", new Object[]{state});
        }
        return ub.build(new Object[0]).normalize();
    }

    private Client getClient(MultivaluedMap<String, String> params, IdToken idTokenHint) {
        String clientId = (String)params.getFirst((Object)"client_id");
        if (clientId == null && idTokenHint != null) {
            clientId = idTokenHint.getAudience();
            this.mc.getHttpServletRequest().setAttribute("client_id", (Object)clientId);
        }
        if (clientId == null) {
            throw new BadRequestException();
        }
        Client c = this.dataProvider.getClient(clientId);
        if (c == null) {
            throw new BadRequestException();
        }
        if (StringUtils.isEmpty((String)((String)c.getProperties().get(CLIENT_LOGOUT_URIS)))) {
            throw new BadRequestException();
        }
        return c;
    }

    private URI getAbsoluteIdpLogoutUri(Client client, MultivaluedMap<String, String> params) {
        UriBuilder ub = this.mc.getUriInfo().getAbsolutePathBuilder().path(this.relativeIdpLogoutUri).queryParam("wreply", new Object[]{LogoutService.getClientLogoutUri(client, params)}).queryParam("client_id", new Object[]{client.getClientId()});
        return ub.build(new Object[0]).normalize();
    }

    public void setRelativeIdpLogoutUri(String relativeIdpLogoutUri) {
        this.relativeIdpLogoutUri = relativeIdpLogoutUri;
    }

    public void setLogoutHandlers(List<LogoutHandler> logoutHandlers) {
        this.logoutHandlers = logoutHandlers;
    }

    public void setLogoutHandler(LogoutHandler logoutHandler) {
        this.setLogoutHandlers(Collections.singletonList(logoutHandler));
    }

    public void setDataProvider(OAuthDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public void setSubjectCreator(FedizSubjectCreator subjectCreator) {
        this.subjectCreator = subjectCreator;
    }

    public void setBackChannelLogoutHandler(BackChannelLogoutHandler handler) {
        this.backChannelLogoutHandler = handler;
    }

    public void setAllowAnonymousLogout(boolean allowAnonymousLogout) {
        this.allowAnonymousLogout = allowAnonymousLogout;
    }

    public void close() {
        if (this.backChannelLogoutHandler != null) {
            this.backChannelLogoutHandler.close();
        }
    }
}

