/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.oidc.logout;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import javax.ws.rs.core.Form;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.rs.security.jose.jwt.JoseJwtProducer;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oidc.common.IdToken;
import org.apache.cxf.rs.security.oidc.idp.OidcUserSubject;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

public class BackChannelLogoutHandler
extends JoseJwtProducer {
    private static final Logger LOG = LogUtils.getL7dLogger(BackChannelLogoutHandler.class);
    private static final String BACK_CHANNEL_LOGOUT_URI = "backchannel_logout_uri";
    private static final String LOGOUT_TOKEN = "logout_token";
    private static final String EVENTS_PROPERTY = "events";
    private static final String BACK_CHANNEL_LOGOUT_EVENT = "http://schemas.openid.net/event/backchannel-logout";
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private OAuthDataProvider dataProvider;

    public void handleLogout(Client client, OidcUserSubject subject, IdToken idTokenHint) {
        List accessTokens = this.dataProvider.getAccessTokens(null, (UserSubject)subject);
        HashSet<String> processedClients = new HashSet<String>();
        for (ServerAccessToken at : accessTokens) {
            String uri;
            Client atClient = at.getClient();
            if (client.getClientId().equals(atClient.getClientId()) || processedClients.contains(atClient.getClientId()) || (uri = (String)atClient.getProperties().get(BACK_CHANNEL_LOGOUT_URI)) == null) continue;
            processedClients.add(atClient.getClientId());
            this.submitBackChannelLogoutRequest(atClient, subject, idTokenHint, uri);
        }
    }

    private void submitBackChannelLogoutRequest(final Client client, final OidcUserSubject subject, IdToken idTokenHint, final String uri) {
        final WebClient wc = WebClient.create((String)uri);
        IdToken idToken = idTokenHint != null ? idTokenHint : subject.getIdToken();
        JwtClaims claims = new JwtClaims();
        claims.setIssuer(idToken.getIssuer());
        claims.setSubject(idToken.getSubject());
        claims.setAudience(client.getClientId());
        claims.setIssuedAt(Long.valueOf(System.currentTimeMillis() / 1000L));
        claims.setTokenId(Base64UrlUtility.encode((byte[])CryptoUtils.generateSecureRandomBytes((int)16)));
        claims.setClaim(EVENTS_PROPERTY, Collections.singletonMap(BACK_CHANNEL_LOGOUT_EVENT, Collections.emptyMap()));
        if (idToken.getName() != null) {
            claims.setClaim("name", (Object)idToken.getName());
        }
        final String logoutToken = super.processJwt(new JwtToken(claims));
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    wc.form(new Form().param(BackChannelLogoutHandler.LOGOUT_TOKEN, logoutToken));
                }
                catch (Exception ex) {
                    LOG.info(String.format("Back channel request to %s to log out %s from client %s has failed", uri, subject.getLogin(), client.getClientId()));
                    LOG.fine(String.format("%s request failure: %s", uri, ExceptionUtils.getStackTrace((Throwable)ex)));
                }
            }
        });
    }

    public void setDataProvider(OAuthDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public void close() {
        this.executorService.shutdownNow();
    }
}

