/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.oidc.handler.hrd;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.cxf.fediz.core.spi.HomeRealmCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginHintHomeRealmDiscovery
implements CallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LoginHintHomeRealmDiscovery.class);

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof HomeRealmCallback) {
                HomeRealmCallback callback = (HomeRealmCallback)callbacks[i];
                String loginHint = callback.getRequest().getParameter("login_hint");
                if (loginHint == null || loginHint.isEmpty()) {
                    LOG.debug("No login_hint found in request to set home realm");
                    continue;
                }
                String[] homeRealm = loginHint.split("@");
                if (homeRealm.length == 2) {
                    LOG.debug("Home realm '{}' found in request", (Object)StringEscapeUtils.escapeHtml4((String)homeRealm[1]));
                    callback.setHomeRealm(homeRealm[1]);
                    continue;
                }
                LOG.warn("login_hint is not an email address: {}", (Object)StringEscapeUtils.escapeHtml4((String)loginHint));
                continue;
            }
            LOG.warn("Callback is not an instance of HomeRealmCallback: {}", (Object)callbacks[i]);
        }
    }
}

