/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.oidc;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.security.NamePasswordCallbackHandler;
import org.apache.cxf.rs.security.oauth2.provider.ProviderAuthenticationStrategy;

public class JAASAuthenticationStrategy
implements ProviderAuthenticationStrategy {
    private static final Logger LOG = LogUtils.getL7dLogger(JAASAuthenticationStrategy.class);
    private String contextName;
    private Configuration loginConfig;

    public boolean authenticate(String name, String password) {
        if (this.contextName != null) {
            try {
                NamePasswordCallbackHandler callbackHandler = new NamePasswordCallbackHandler(name, password);
                LoginContext ctx = new LoginContext(this.contextName, null, (CallbackHandler)callbackHandler, this.loginConfig);
                ctx.login();
                ctx.logout();
                return true;
            }
            catch (LoginException ex) {
                String errorMessage = "Authentication failed: " + ex.getMessage();
                LOG.log(Level.FINE, errorMessage, ex);
            }
        }
        return false;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public void setLoginConfig(Configuration loginConfig) {
        this.loginConfig = loginConfig;
    }
}

