/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.oidc;

import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.fediz.core.Claim;
import org.apache.cxf.fediz.core.ClaimCollection;
import org.apache.cxf.fediz.core.ClaimTypes;
import org.apache.cxf.fediz.core.FedizConstants;
import org.apache.cxf.fediz.core.FedizPrincipal;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.provider.SubjectCreator;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.apache.cxf.rs.security.oidc.common.IdToken;
import org.apache.cxf.rs.security.oidc.idp.OidcUserSubject;
import org.apache.cxf.rs.security.oidc.utils.OidcUtils;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.joda.time.DateTime;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Issuer;
import org.w3c.dom.Element;

public class FedizSubjectCreator
implements SubjectCreator {
    private static final long DEFAULT_TIME_TO_LIVE = 3600L;
    private static final String ROLES_SCOPE = "roles";
    private boolean stripPathFromIssuerUri;
    private String issuer;
    private Map<String, String> supportedClaims = Collections.emptyMap();
    private long timeToLive;

    public OidcUserSubject createUserSubject(MessageContext mc, MultivaluedMap<String, String> params) {
        Principal principal = mc.getSecurityContext().getUserPrincipal();
        if (!(principal instanceof FedizPrincipal)) {
            throw new OAuthServiceException("Unsupported Principal");
        }
        FedizPrincipal fedizPrincipal = (FedizPrincipal)principal;
        OidcUserSubject oidcSub = new OidcUserSubject();
        oidcSub.setLogin(fedizPrincipal.getName());
        oidcSub.setId(fedizPrincipal.getName());
        IdToken idToken = this.convertToIdToken(mc, fedizPrincipal.getLoginToken(), oidcSub.getLogin(), oidcSub.getId(), fedizPrincipal.getClaims(), fedizPrincipal.getRoleClaims(), params);
        oidcSub.setIdToken(idToken);
        oidcSub.setRoles(fedizPrincipal.getRoleClaims());
        return oidcSub;
    }

    private IdToken convertToIdToken(MessageContext mc, Element samlToken, String subjectName, String subjectId, ClaimCollection claims, List<String> roles, MultivaluedMap<String, String> params) {
        String roleClaimName;
        String requestedClaims;
        Issuer assertionIssuer;
        IdToken idToken = new IdToken();
        idToken.setPreferredUserName(subjectName);
        idToken.setSubject(subjectId);
        Assertion saml2Assertion = this.getSaml2Assertion(samlToken);
        if (saml2Assertion != null && !saml2Assertion.getAuthnStatements().isEmpty()) {
            DateTime authInstant = ((AuthnStatement)saml2Assertion.getAuthnStatements().get(0)).getAuthnInstant();
            idToken.setAuthenticationTime(Long.valueOf(authInstant.getMillis() / 1000L));
        }
        if (this.issuer != null) {
            String realIssuer;
            if (this.issuer.startsWith("/")) {
                UriBuilder ub = mc.getUriInfo().getBaseUriBuilder();
                URI uri = ub.path(this.issuer).build(new Object[0]);
                if (this.stripPathFromIssuerUri) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(uri.getScheme()).append("://").append(uri.getHost());
                    if (uri.getPort() != -1) {
                        sb.append(':').append(uri.getPort());
                    }
                    realIssuer = sb.toString();
                } else {
                    realIssuer = uri.toString();
                }
            } else {
                realIssuer = this.issuer;
            }
            idToken.setIssuer(realIssuer);
        } else if (saml2Assertion != null && (assertionIssuer = saml2Assertion.getIssuer()) != null) {
            idToken.setIssuer(assertionIssuer.getValue());
        }
        idToken.setTokenId(OAuthUtils.generateRandomTokenKey());
        long iat = OAuthUtils.getIssuedAt();
        idToken.setIssuedAt(Long.valueOf(iat));
        HttpSession httpSession = mc.getHttpServletRequest().getSession(false);
        if (this.timeToLive > 0L) {
            idToken.setExpiryTime(Long.valueOf(iat + this.timeToLive));
        } else if (httpSession != null && httpSession.getMaxInactiveInterval() > 0) {
            idToken.setExpiryTime(Long.valueOf(iat + (long)httpSession.getMaxInactiveInterval()));
        } else {
            idToken.setExpiryTime(Long.valueOf(iat + 3600L));
        }
        ArrayList<String> requestedClaimsList = new ArrayList<String>();
        String requestedScope = (String)params.getFirst((Object)"scope");
        if (requestedScope != null && !requestedScope.isEmpty()) {
            String[] scopes = requestedScope.split(" ");
            requestedClaimsList.addAll(OidcUtils.getScopeClaims((String[])scopes));
            requestedClaimsList.addAll(this.getCustomScopeClaims(scopes));
        }
        if ((requestedClaims = (String)params.getFirst((Object)"claims")) != null && !requestedClaims.isEmpty()) {
            requestedClaimsList.addAll(Arrays.asList(requestedClaims.trim().split(" ")));
        }
        if (claims != null) {
            String firstName = null;
            String lastName = null;
            for (Claim c : claims) {
                if (!(c.getValue() instanceof String)) continue;
                if (ClaimTypes.FIRSTNAME.equals(c.getClaimType())) {
                    idToken.setGivenName((String)c.getValue());
                    firstName = (String)c.getValue();
                    continue;
                }
                if (ClaimTypes.LASTNAME.equals(c.getClaimType())) {
                    idToken.setFamilyName((String)c.getValue());
                    lastName = (String)c.getValue();
                    continue;
                }
                if (ClaimTypes.EMAILADDRESS.equals(c.getClaimType())) {
                    idToken.setEmail((String)c.getValue());
                    continue;
                }
                if (!this.supportedClaims.containsKey(c.getClaimType().toString()) || !requestedClaimsList.contains(this.supportedClaims.get(c.getClaimType().toString()))) continue;
                idToken.setClaim(this.supportedClaims.get(c.getClaimType().toString()), c.getValue());
            }
            if (firstName != null && lastName != null) {
                idToken.setName(firstName + " " + lastName);
            }
        }
        if (roles != null && !roles.isEmpty() && this.supportedClaims.containsKey(FedizConstants.DEFAULT_ROLE_URI.toString()) && requestedClaimsList.contains(roleClaimName = this.supportedClaims.get(FedizConstants.DEFAULT_ROLE_URI.toString()))) {
            idToken.setClaim(roleClaimName, roles);
        }
        return idToken;
    }

    private List<String> getCustomScopeClaims(String[] scopes) {
        String roleClaimName = this.supportedClaims.get(FedizConstants.DEFAULT_ROLE_URI.toString());
        if (roleClaimName != null && Arrays.asList(scopes).contains(ROLES_SCOPE)) {
            return Collections.singletonList(roleClaimName);
        }
        return Collections.emptyList();
    }

    private Assertion getSaml2Assertion(Element samlToken) {
        try {
            SamlAssertionWrapper wrapper = new SamlAssertionWrapper(samlToken);
            return wrapper.getSaml2();
        }
        catch (WSSecurityException ex) {
            throw new OAuthServiceException("Error converting SAML token", (Throwable)ex);
        }
    }

    public void setIdTokenIssuer(String idTokenIssuer) {
        this.issuer = idTokenIssuer;
    }

    public void setSupportedClaims(Map<String, String> supportedClaims) {
        this.supportedClaims = supportedClaims;
    }

    public void setStripPathFromIssuerUri(boolean stripPathFromIssuerUri) {
        this.stripPathFromIssuerUri = stripPathFromIssuerUri;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }
}

