/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.service.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.cxf.fediz.service.idp.domain.Entitlement;
import org.apache.cxf.fediz.service.idp.domain.Role;
import org.apache.cxf.fediz.service.idp.service.RoleDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class GrantedAuthorityEntitlements
extends GenericFilterBean {
    private static final Logger LOG = LoggerFactory.getLogger(GrantedAuthorityEntitlements.class);
    @Autowired
    private RoleDAO roleDAO;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            Authentication currentAuth = SecurityContextHolder.getContext().getAuthentication();
            if (currentAuth == null) {
                chain.doFilter(request, response);
                return;
            }
            HashSet<SimpleGrantedAuthority> authorities = new HashSet<SimpleGrantedAuthority>();
            if (currentAuth.getAuthorities() != null) {
                authorities.addAll(currentAuth.getAuthorities());
            }
            for (GrantedAuthority ga : currentAuth.getAuthorities()) {
                String roleName = ga.getAuthority();
                try {
                    Role role = this.roleDAO.getRole(roleName.substring(5), Arrays.asList("all"));
                    for (Entitlement e : role.getEntitlements()) {
                        authorities.add(new SimpleGrantedAuthority(e.getName()));
                    }
                }
                catch (Exception ex) {
                    LOG.error("Role '{}' not found", (Object)roleName);
                }
            }
            LOG.debug("Granted Authorities: {}", authorities);
            UsernamePasswordAuthenticationToken enrichedAuthentication = new UsernamePasswordAuthenticationToken((Object)currentAuth.getName(), currentAuth.getCredentials(), authorities);
            enrichedAuthentication.setDetails(currentAuth.getDetails());
            SecurityContextHolder.getContext().setAuthentication((Authentication)enrichedAuthentication);
            LOG.info("Enriched AuthenticationToken added");
        }
        catch (Exception ex) {
            LOG.error("Failed to enrich security context with entitlements", (Throwable)ex);
        }
        chain.doFilter(request, response);
    }
}

