/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.service.jpa;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.cxf.fediz.service.idp.domain.TrustedIdp;
import org.apache.cxf.fediz.service.idp.service.TrustedIdpDAO;
import org.apache.cxf.fediz.service.idp.service.jpa.TrustedIdpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Transactional
@Repository
public class TrustedIdpDAOJPAImpl
implements TrustedIdpDAO {
    private static final Logger LOG = LoggerFactory.getLogger(TrustedIdpDAOJPAImpl.class);
    private EntityManager em;

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager) {
        this.em = entityManager;
    }

    public List<TrustedIdp> getTrustedIDPs(int start, int size) {
        ArrayList<TrustedIdp> list = new ArrayList<TrustedIdp>();
        Query query = null;
        query = this.em.createQuery("select t from TrustedIDP t");
        List idpEntities = query.setFirstResult(start).setMaxResults(size).getResultList();
        for (Object obj : idpEntities) {
            TrustedIdpEntity entity = (TrustedIdpEntity)obj;
            list.add(TrustedIdpDAOJPAImpl.entity2domain((TrustedIdpEntity)entity));
        }
        return list;
    }

    public TrustedIdp getTrustedIDP(String realm) {
        return TrustedIdpDAOJPAImpl.entity2domain((TrustedIdpEntity)TrustedIdpDAOJPAImpl.getTrustedIdpEntity((String)realm, (EntityManager)this.em));
    }

    public TrustedIdp addTrustedIDP(TrustedIdp trustedIdp) {
        TrustedIdpEntity entity = new TrustedIdpEntity();
        TrustedIdpDAOJPAImpl.domain2entity((TrustedIdp)trustedIdp, (TrustedIdpEntity)entity);
        this.em.persist((Object)entity);
        LOG.debug("Trusted IDP '" + trustedIdp.getRealm() + "' added");
        return TrustedIdpDAOJPAImpl.entity2domain((TrustedIdpEntity)entity);
    }

    public void updateTrustedIDP(String realm, TrustedIdp trustedIdp) {
        TrustedIdpEntity trustedIdpEntity = TrustedIdpDAOJPAImpl.getTrustedIdpEntity((String)realm, (EntityManager)this.em);
        TrustedIdpDAOJPAImpl.domain2entity((TrustedIdp)trustedIdp, (TrustedIdpEntity)trustedIdpEntity);
        this.em.persist((Object)trustedIdpEntity);
        LOG.debug("Trusted IDP '" + trustedIdp.getRealm() + "' updated");
    }

    public void deleteTrustedIDP(String realm) {
        Query query = null;
        query = this.em.createQuery("select t from TrustedIDP t where t.realm=:realm");
        query.setParameter("realm", (Object)realm);
        Object trustedIdpObj = query.getSingleResult();
        this.em.remove(trustedIdpObj);
        LOG.debug("Trusted IDP '" + realm + "' deleted");
    }

    static TrustedIdpEntity getTrustedIdpEntity(String realm, EntityManager em) {
        Query query = null;
        query = em.createQuery("select t from TrustedIDP t where t.realm=:realm");
        query.setParameter("realm", (Object)realm);
        return (TrustedIdpEntity)query.getSingleResult();
    }

    public static void domain2entity(TrustedIdp trustedIDP, TrustedIdpEntity entity) {
        if (trustedIDP.getId() > 0) {
            entity.setId(trustedIDP.getId());
        }
        entity.setCacheTokens(trustedIDP.isCacheTokens());
        entity.setCertificate(trustedIDP.getCertificate());
        entity.setDescription(trustedIDP.getDescription());
        entity.setFederationType(trustedIDP.getFederationType());
        entity.setLogo(trustedIDP.getLogo());
        entity.setName(trustedIDP.getName());
        entity.setProtocol(trustedIDP.getProtocol());
        entity.setRealm(trustedIDP.getRealm());
        entity.setIssuer(trustedIDP.getIssuer());
        entity.setTrustType(trustedIDP.getTrustType());
        entity.setUrl(trustedIDP.getUrl());
        entity.setParameters(trustedIDP.getParameters());
    }

    public static TrustedIdp entity2domain(TrustedIdpEntity entity) {
        TrustedIdp trustedIDP = new TrustedIdp();
        trustedIDP.setId(entity.getId());
        trustedIDP.setCacheTokens(entity.isCacheTokens());
        trustedIDP.setCertificate(entity.getCertificate());
        trustedIDP.setDescription(entity.getDescription());
        trustedIDP.setFederationType(entity.getFederationType());
        trustedIDP.setLogo(entity.getLogo());
        trustedIDP.setName(entity.getName());
        trustedIDP.setProtocol(entity.getProtocol());
        trustedIDP.setRealm(entity.getRealm());
        trustedIDP.setIssuer(entity.getIssuer());
        trustedIDP.setTrustType(entity.getTrustType());
        trustedIDP.setUrl(entity.getUrl());
        trustedIDP.setParameters(entity.getParameters());
        return trustedIDP;
    }
}

