/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.service.jpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.cxf.fediz.service.idp.domain.Application;
import org.apache.cxf.fediz.service.idp.domain.Claim;
import org.apache.cxf.fediz.service.idp.domain.Idp;
import org.apache.cxf.fediz.service.idp.domain.TrustedIdp;
import org.apache.cxf.fediz.service.idp.service.IdpDAO;
import org.apache.cxf.fediz.service.idp.service.jpa.ApplicationDAOJPAImpl;
import org.apache.cxf.fediz.service.idp.service.jpa.ApplicationEntity;
import org.apache.cxf.fediz.service.idp.service.jpa.ClaimDAOJPAImpl;
import org.apache.cxf.fediz.service.idp.service.jpa.ClaimEntity;
import org.apache.cxf.fediz.service.idp.service.jpa.IdpEntity;
import org.apache.cxf.fediz.service.idp.service.jpa.TrustedIdpDAOJPAImpl;
import org.apache.cxf.fediz.service.idp.service.jpa.TrustedIdpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Repository
@Transactional
public class IdpDAOJPAImpl
implements IdpDAO {
    private static final Logger LOG = LoggerFactory.getLogger(IdpDAOJPAImpl.class);
    private EntityManager em;

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager) {
        this.em = entityManager;
    }

    public List<Idp> getIdps(int start, int size, List<String> expandList) {
        ArrayList<Idp> list = new ArrayList<Idp>();
        Query query = null;
        query = this.em.createQuery("select i from IDP i");
        List idpEntities = query.setFirstResult(start).setMaxResults(size).getResultList();
        for (Object obj : idpEntities) {
            IdpEntity entity = (IdpEntity)obj;
            list.add(IdpDAOJPAImpl.entity2domain((IdpEntity)entity, expandList));
        }
        return list;
    }

    public Idp getIdp(String realm, List<String> expandList) {
        Query query = null;
        query = this.em.createQuery("select i from IDP i where i.realm=:realm");
        query.setParameter("realm", (Object)realm);
        Object idpObj = query.getSingleResult();
        return IdpDAOJPAImpl.entity2domain((IdpEntity)((IdpEntity)idpObj), expandList);
    }

    public Idp addIdp(Idp idp) {
        IdpEntity entity = new IdpEntity();
        IdpDAOJPAImpl.domain2entity((Idp)idp, (IdpEntity)entity);
        this.em.persist((Object)entity);
        LOG.debug("IDP '{}' added", (Object)idp.getRealm());
        return IdpDAOJPAImpl.entity2domain((IdpEntity)entity, Arrays.asList("all"));
    }

    public void updateIdp(String realm, Idp idp) {
        Query query = null;
        query = this.em.createQuery("select i from IDP i where i.realm=:realm");
        query.setParameter("realm", (Object)realm);
        IdpEntity idpEntity = (IdpEntity)query.getSingleResult();
        IdpDAOJPAImpl.domain2entity((Idp)idp, (IdpEntity)idpEntity);
        this.em.persist((Object)idpEntity);
        LOG.debug("IDP '{}' updated", (Object)idp.getRealm());
    }

    public void deleteIdp(String realm) {
        Query query = null;
        query = this.em.createQuery("select i from IDP i where i.realm=:realm");
        query.setParameter("realm", (Object)realm);
        Object idpObj = query.getSingleResult();
        this.em.remove(idpObj);
        LOG.debug("IDP '{}' deleted", (Object)realm);
    }

    public void addApplicationToIdp(Idp idp, Application application) {
        IdpEntity idpEntity = null;
        idpEntity = idp.getId() != 0 ? (IdpEntity)this.em.find(IdpEntity.class, (Object)idp.getId()) : IdpDAOJPAImpl.getIdpEntity((String)idp.getRealm(), (EntityManager)this.em);
        ApplicationEntity applicationEntity = null;
        applicationEntity = application.getId() != 0 ? (ApplicationEntity)this.em.find(ApplicationEntity.class, (Object)application.getId()) : ApplicationDAOJPAImpl.getApplicationEntity((String)application.getRealm(), (EntityManager)this.em);
        idpEntity.getApplications().add(applicationEntity);
        LOG.debug("Application '{}' added to IDP '{}'", (Object)application.getRealm(), (Object)idp.getRealm());
    }

    public void removeApplicationFromIdp(Idp idp, Application application) {
        IdpEntity idpEntity = null;
        idpEntity = idp.getId() != 0 ? (IdpEntity)this.em.find(IdpEntity.class, (Object)idp.getId()) : IdpDAOJPAImpl.getIdpEntity((String)idp.getRealm(), (EntityManager)this.em);
        ApplicationEntity applicationEntity = null;
        applicationEntity = application.getId() != 0 ? (ApplicationEntity)this.em.find(ApplicationEntity.class, (Object)application.getId()) : ApplicationDAOJPAImpl.getApplicationEntity((String)application.getRealm(), (EntityManager)this.em);
        if (applicationEntity == null) {
            throw new EntityNotFoundException("ApplicationEntity not found");
        }
        if (!idpEntity.getApplications().remove(applicationEntity)) {
            throw new EntityNotFoundException("ApplicationEntity not assigned to IdpEntity");
        }
        LOG.debug("Application '{}' removed from IDP '{}'", (Object)application.getRealm(), (Object)idp.getRealm());
    }

    public void addTrustedIdpToIdp(Idp idp, TrustedIdp trustedIdp) {
        IdpEntity idpEntity = null;
        idpEntity = idp.getId() != 0 ? (IdpEntity)this.em.find(IdpEntity.class, (Object)idp.getId()) : IdpDAOJPAImpl.getIdpEntity((String)idp.getRealm(), (EntityManager)this.em);
        TrustedIdpEntity trustedIdpEntity = null;
        trustedIdpEntity = trustedIdp.getId() != 0 ? (TrustedIdpEntity)this.em.find(TrustedIdpEntity.class, (Object)trustedIdp.getId()) : TrustedIdpDAOJPAImpl.getTrustedIdpEntity((String)trustedIdp.getRealm(), (EntityManager)this.em);
        idpEntity.getTrustedIdps().add(trustedIdpEntity);
        LOG.debug("Trusted IDP '{}' added to IDP '{}'", (Object)trustedIdp.getRealm(), (Object)idp.getRealm());
    }

    public void removeTrustedIdpFromIdp(Idp idp, TrustedIdp trustedIdp) {
        IdpEntity idpEntity = null;
        idpEntity = idp.getId() != 0 ? (IdpEntity)this.em.find(IdpEntity.class, (Object)idp.getId()) : IdpDAOJPAImpl.getIdpEntity((String)idp.getRealm(), (EntityManager)this.em);
        TrustedIdpEntity trustedIdpEntity = null;
        trustedIdpEntity = trustedIdp.getId() != 0 ? (TrustedIdpEntity)this.em.find(TrustedIdpEntity.class, (Object)trustedIdp.getId()) : TrustedIdpDAOJPAImpl.getTrustedIdpEntity((String)trustedIdp.getRealm(), (EntityManager)this.em);
        idpEntity.getTrustedIdps().remove(trustedIdpEntity);
        LOG.debug("Trusted IDP '{}' removed from IDP '{}'", (Object)trustedIdp.getRealm(), (Object)idp.getRealm());
    }

    public void addClaimToIdp(Idp idp, Claim claim) {
        IdpEntity idpEntity = null;
        idpEntity = idp.getId() != 0 ? (IdpEntity)this.em.find(IdpEntity.class, (Object)idp.getId()) : IdpDAOJPAImpl.getIdpEntity((String)idp.getRealm(), (EntityManager)this.em);
        ClaimEntity claimEntity = null;
        claimEntity = claim.getId() != 0 ? (ClaimEntity)this.em.find(ClaimEntity.class, (Object)claim.getId()) : ClaimDAOJPAImpl.getClaimEntity((String)claim.getClaimType().toString(), (EntityManager)this.em);
        idpEntity.getClaimTypesOffered().add(claimEntity);
        LOG.debug("Claim '{}' added to IDP '{}'", (Object)claim.getClaimType(), (Object)idp.getRealm());
    }

    public void removeClaimFromIdp(Idp idp, Claim claim) {
        IdpEntity idpEntity = null;
        idpEntity = idp.getId() != 0 ? (IdpEntity)this.em.find(IdpEntity.class, (Object)idp.getId()) : IdpDAOJPAImpl.getIdpEntity((String)idp.getRealm(), (EntityManager)this.em);
        if (idpEntity == null) {
            throw new EntityNotFoundException("IdpEntity not found");
        }
        ClaimEntity claimEntity = null;
        claimEntity = claim.getId() != 0 ? (ClaimEntity)this.em.find(ClaimEntity.class, (Object)claim.getId()) : ClaimDAOJPAImpl.getClaimEntity((String)claim.getClaimType().toString(), (EntityManager)this.em);
        if (claimEntity == null) {
            throw new EntityNotFoundException("ClaimEntity not found");
        }
        if (!idpEntity.getClaimTypesOffered().remove(claimEntity)) {
            throw new EntityNotFoundException("ClaimEntity not assigned to IdpEntity");
        }
        LOG.debug("Claim '{}' removed from IDP '{}'", (Object)claim.getClaimType(), (Object)idp.getRealm());
    }

    static IdpEntity getIdpEntity(String realm, EntityManager em) {
        Query query = null;
        query = em.createQuery("select i from IDP i where i.realm=:realm");
        query.setParameter("realm", (Object)realm);
        return (IdpEntity)query.getSingleResult();
    }

    public static void domain2entity(Idp idp, IdpEntity entity) {
        if (idp.getId() > 0) {
            entity.setId(idp.getId());
        }
        entity.setCertificate(idp.getCertificate());
        entity.setCertificatePassword(idp.getCertificatePassword());
        entity.setRealm(idp.getRealm());
        entity.setServiceDescription(idp.getServiceDescription());
        entity.setServiceDisplayName(idp.getServiceDisplayName());
        entity.setHrds(idp.getHrds());
        entity.setIdpUrl(idp.getIdpUrl());
        entity.setProvideIdpList(idp.isProvideIdpList());
        entity.setStsUrl(idp.getStsUrl());
        entity.setUri(idp.getUri());
        entity.setUseCurrentIdp(idp.isUseCurrentIdp());
        entity.setRpSingleSignOutConfirmation(idp.isRpSingleSignOutConfirmation());
        entity.setRpSingleSignOutCleanupConfirmation(idp.isRpSingleSignOutCleanupConfirmation());
        entity.getAuthenticationURIs().clear();
        for (Map.Entry entry : idp.getAuthenticationURIs().entrySet()) {
            entity.getAuthenticationURIs().put(entry.getKey(), entry.getValue());
        }
        entity.getTokenTypesOffered().clear();
        for (String string : idp.getTokenTypesOffered()) {
            entity.getTokenTypesOffered().add(string);
        }
        entity.getSupportedProtocols().clear();
        for (String string : idp.getSupportedProtocols()) {
            entity.getSupportedProtocols().add(string);
        }
    }

    public static Idp entity2domain(IdpEntity entity, List<String> expandList) {
        Idp idp = new Idp();
        idp.setId(entity.getId());
        idp.setCertificate(entity.getCertificate());
        idp.setCertificatePassword(entity.getCertificatePassword());
        idp.setRealm(entity.getRealm());
        idp.setServiceDescription(entity.getServiceDescription());
        idp.setServiceDisplayName(entity.getServiceDisplayName());
        idp.setHrds(entity.getHrds());
        idp.setIdpUrl(entity.getIdpUrl());
        idp.setProvideIdpList(entity.isProvideIdpList());
        idp.setStsUrl(entity.getStsUrl());
        idp.setUri(entity.getUri());
        idp.setUseCurrentIdp(entity.isUseCurrentIdp());
        idp.setRpSingleSignOutConfirmation(entity.isRpSingleSignOutConfirmation());
        idp.setRpSingleSignOutCleanupConfirmation(entity.isRpSingleSignOutCleanupConfirmation());
        if (expandList != null && (expandList.contains("all") || expandList.contains("applications"))) {
            for (ApplicationEntity applicationEntity : entity.getApplications()) {
                Application application = ApplicationDAOJPAImpl.entity2domain((ApplicationEntity)applicationEntity, expandList);
                idp.getApplications().add(application);
            }
        }
        if (expandList != null && (expandList.contains("all") || expandList.contains("trusted-idps"))) {
            for (TrustedIdpEntity trustedIdpEntity : entity.getTrustedIdps()) {
                TrustedIdp trustedIdp = TrustedIdpDAOJPAImpl.entity2domain((TrustedIdpEntity)trustedIdpEntity);
                idp.getTrustedIdps().add(trustedIdp);
            }
        }
        for (Map.Entry entry : entity.getAuthenticationURIs().entrySet()) {
            idp.getAuthenticationURIs().put(entry.getKey(), entry.getValue());
        }
        for (String string : entity.getTokenTypesOffered()) {
            idp.getTokenTypesOffered().add(string);
        }
        for (String string : entity.getSupportedProtocols()) {
            idp.getSupportedProtocols().add(string);
        }
        if (expandList != null && (expandList.contains("all") || expandList.contains("claims"))) {
            for (ClaimEntity claimEntity : entity.getClaimTypesOffered()) {
                idp.getClaimTypesOffered().add(ClaimDAOJPAImpl.entity2domain((ClaimEntity)claimEntity));
            }
        }
        return idp;
    }
}

