/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.service.jpa;

import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.cxf.fediz.service.idp.service.jpa.ApplicationClaimEntity;
import org.apache.cxf.fediz.service.idp.service.jpa.ApplicationEntity;
import org.apache.cxf.fediz.service.idp.service.jpa.ClaimEntity;
import org.apache.cxf.fediz.service.idp.service.jpa.DBLoader;
import org.apache.cxf.fediz.service.idp.service.jpa.EntitlementEntity;
import org.apache.cxf.fediz.service.idp.service.jpa.IdpEntity;
import org.apache.cxf.fediz.service.idp.service.jpa.RoleEntity;
import org.apache.cxf.fediz.service.idp.service.jpa.TrustedIdpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DBLoaderSpring
implements DBLoader {
    public static final String NAME = "SPRINGDBLOADER";
    private static final Logger LOG = LoggerFactory.getLogger(DBLoaderSpring.class);
    private EntityManager em;
    private String resource;

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager) {
        this.em = entityManager;
    }

    public String getName() {
        return NAME;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        try (GenericXmlApplicationContext ctx = null;){
            if (this.resource == null) {
                LOG.warn("Resource null for DBLoaderSpring");
            }
            ctx = new GenericXmlApplicationContext();
            ctx.load(new String[]{this.resource});
            ctx.refresh();
            ctx.start();
            Collection entitlements = ctx.getBeansOfType(EntitlementEntity.class, true, true).values();
            for (EntitlementEntity e : entitlements) {
                this.em.persist((Object)e);
            }
            LOG.info(entitlements.size() + " EntitlementEntity added");
            Collection roles = ctx.getBeansOfType(RoleEntity.class, true, true).values();
            for (RoleEntity r : roles) {
                this.em.persist((Object)r);
            }
            LOG.info(roles.size() + " RoleEntity added");
            Collection claims = ctx.getBeansOfType(ClaimEntity.class, true, true).values();
            for (ClaimEntity c : claims) {
                this.em.persist((Object)c);
            }
            LOG.info(claims.size() + " ClaimEntity added");
            Collection trustedIdps = ctx.getBeansOfType(TrustedIdpEntity.class).values();
            for (TrustedIdpEntity t : trustedIdps) {
                this.em.persist((Object)t);
            }
            LOG.info(trustedIdps.size() + " TrustedIdpEntity added");
            Collection applications = ctx.getBeansOfType(ApplicationEntity.class).values();
            for (ApplicationEntity a : applications) {
                this.em.persist((Object)a);
            }
            LOG.info(applications.size() + " ApplicationEntity added");
            Collection idps = ctx.getBeansOfType(IdpEntity.class).values();
            for (IdpEntity i : idps) {
                this.em.persist((Object)i);
            }
            LOG.info(idps.size() + " IdpEntity added");
            Collection applicationClaims = ctx.getBeansOfType(ApplicationClaimEntity.class).values();
            for (ApplicationClaimEntity ac : applicationClaims) {
                this.em.persist((Object)ac);
            }
            LOG.info(applicationClaims.size() + " ApplicationClaimEntity added");
            this.em.flush();
        }
    }
}

