/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.service.jpa;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.cxf.fediz.service.idp.domain.Claim;
import org.apache.cxf.fediz.service.idp.service.ClaimDAO;
import org.apache.cxf.fediz.service.idp.service.jpa.ClaimEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Repository
@Transactional
public class ClaimDAOJPAImpl
implements ClaimDAO {
    private static final Logger LOG = LoggerFactory.getLogger(ClaimDAOJPAImpl.class);
    private EntityManager em;

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager) {
        this.em = entityManager;
    }

    public List<Claim> getClaims(int start, int size) {
        ArrayList<Claim> list = new ArrayList<Claim>();
        Query query = null;
        query = this.em.createQuery("select c from Claim c");
        List claimEntities = query.setFirstResult(start).setMaxResults(size).getResultList();
        for (Object obj : claimEntities) {
            ClaimEntity entity = (ClaimEntity)obj;
            list.add(ClaimDAOJPAImpl.entity2domain((ClaimEntity)entity));
        }
        return list;
    }

    public Claim addClaim(Claim claim) {
        ClaimEntity entity = new ClaimEntity();
        ClaimDAOJPAImpl.domain2entity((Claim)claim, (ClaimEntity)entity);
        this.em.persist((Object)entity);
        LOG.debug("Claim '{}' added", (Object)claim.getClaimType());
        return ClaimDAOJPAImpl.entity2domain((ClaimEntity)entity);
    }

    public Claim getClaim(String claimType) {
        return ClaimDAOJPAImpl.entity2domain((ClaimEntity)ClaimDAOJPAImpl.getClaimEntity((String)claimType, (EntityManager)this.em));
    }

    public void updateClaim(String claimType, Claim claim) {
        Query query = null;
        query = this.em.createQuery("select c from Claim c where c.claimtype=:claimtype");
        query.setParameter("claimtype", (Object)claimType);
        ClaimEntity claimEntity = (ClaimEntity)query.getSingleResult();
        ClaimDAOJPAImpl.domain2entity((Claim)claim, (ClaimEntity)claimEntity);
        LOG.debug("Claim '{}' added", (Object)claim.getClaimType());
        this.em.persist((Object)claimEntity);
    }

    public void deleteClaim(String claimType) {
        Query query = null;
        query = this.em.createQuery("select c from Claim c where c.claimType=:claimtype");
        query.setParameter("claimtype", (Object)claimType);
        Object claimObj = query.getSingleResult();
        this.em.remove(claimObj);
        LOG.debug("Claim '{}' deleted", (Object)claimType);
    }

    static ClaimEntity getClaimEntity(String claimType, EntityManager em) {
        Query query = null;
        query = em.createQuery("select c from Claim c where c.claimType=:claimtype");
        query.setParameter("claimtype", (Object)claimType);
        return (ClaimEntity)query.getSingleResult();
    }

    public static void domain2entity(Claim claim, ClaimEntity entity) {
        if (claim.getId() > 0) {
            entity.setId(claim.getId());
        }
        entity.setClaimType(claim.getClaimType().toString());
        entity.setDisplayName(claim.getDisplayName());
        entity.setDescription(claim.getDescription());
    }

    public static Claim entity2domain(ClaimEntity entity) {
        Claim claim = new Claim();
        claim.setId(entity.getId());
        claim.setClaimType(URI.create(entity.getClaimType()));
        claim.setDisplayName(entity.getDisplayName());
        claim.setDescription(entity.getDescription());
        return claim;
    }
}

