/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.samlsso;

import java.util.UUID;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.StatusMessage;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SAML2PResponseComponentBuilder {
    private static SAMLObjectBuilder<Response> responseBuilder;
    private static SAMLObjectBuilder<Issuer> issuerBuilder;
    private static SAMLObjectBuilder<Status> statusBuilder;
    private static SAMLObjectBuilder<StatusCode> statusCodeBuilder;
    private static SAMLObjectBuilder<StatusMessage> statusMessageBuilder;
    private static XMLObjectBuilderFactory builderFactory;

    private SAML2PResponseComponentBuilder() {
    }

    public static Response createSAMLResponse(String inResponseTo, String issuer, Status status) {
        if (responseBuilder == null) {
            responseBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Response.DEFAULT_ELEMENT_NAME);
        }
        Response response = (Response)responseBuilder.buildObject();
        response.setID(UUID.randomUUID().toString());
        response.setIssueInstant(new DateTime());
        response.setInResponseTo(inResponseTo);
        response.setIssuer(SAML2PResponseComponentBuilder.createIssuer((String)issuer));
        response.setStatus(status);
        response.setVersion(SAMLVersion.VERSION_20);
        return response;
    }

    public static Issuer createIssuer(String issuerValue) {
        if (issuerBuilder == null) {
            issuerBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        }
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setValue(issuerValue);
        return issuer;
    }

    public static Status createStatus(String statusCodeValue, String statusMessage) {
        if (statusBuilder == null) {
            statusBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Status.DEFAULT_ELEMENT_NAME);
        }
        if (statusCodeBuilder == null) {
            statusCodeBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(StatusCode.DEFAULT_ELEMENT_NAME);
        }
        if (statusMessageBuilder == null) {
            statusMessageBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(StatusMessage.DEFAULT_ELEMENT_NAME);
        }
        Status status = (Status)statusBuilder.buildObject();
        StatusCode statusCode = (StatusCode)statusCodeBuilder.buildObject();
        statusCode.setValue(statusCodeValue);
        status.setStatusCode(statusCode);
        if (statusMessage != null) {
            StatusMessage statusMessageObject = (StatusMessage)statusMessageBuilder.buildObject();
            statusMessageObject.setMessage(statusMessage);
            status.setStatusMessage(statusMessageObject);
        }
        return status;
    }

    static {
        builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
    }
}

