/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.samlsso;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.bean.AttributeBean;
import org.apache.wss4j.common.saml.bean.AttributeStatementBean;
import org.apache.wss4j.common.saml.bean.AuthenticationStatementBean;
import org.apache.wss4j.common.saml.bean.ConditionsBean;
import org.apache.wss4j.common.saml.bean.SubjectBean;
import org.apache.wss4j.common.saml.bean.SubjectConfirmationDataBean;
import org.apache.wss4j.common.saml.bean.Version;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.Subject;

public class SAML2CallbackHandler
implements CallbackHandler {
    private Subject subject;
    private String confirmationMethod = "urn:oasis:names:tc:SAML:2.0:cm:bearer";
    private String issuer;
    private ConditionsBean conditions;
    private SubjectConfirmationDataBean subjectConfirmationData;
    private List<AttributeStatement> attributeStatements;

    private void createAndSetStatement(SAMLCallback callback) {
        AuthenticationStatementBean authBean = new AuthenticationStatementBean();
        authBean.setAuthenticationMethod("Password");
        callback.setAuthenticationStatementData(Collections.singletonList(authBean));
        if (this.attributeStatements != null && !this.attributeStatements.isEmpty()) {
            ArrayList<AttributeStatementBean> attrStatementBeans = new ArrayList<AttributeStatementBean>();
            for (AttributeStatement attrStatement : this.attributeStatements) {
                AttributeStatementBean attrStatementBean = new AttributeStatementBean();
                ArrayList<AttributeBean> attrBeans = new ArrayList<AttributeBean>();
                for (Attribute attribute : attrStatement.getAttributes()) {
                    AttributeBean attributeBean = new AttributeBean();
                    attributeBean.setQualifiedName(attribute.getName());
                    attributeBean.setNameFormat(attribute.getNameFormat());
                    ArrayList<String> attributeValues = new ArrayList<String>();
                    for (XMLObject attrVal : attribute.getAttributeValues()) {
                        attributeValues.add(attrVal.getDOM().getTextContent());
                    }
                    attributeBean.setAttributeValues(attributeValues);
                    attrBeans.add(attributeBean);
                }
                attrStatementBean.setSamlAttributes(attrBeans);
                attrStatementBeans.add(attrStatementBean);
            }
            callback.setAttributeStatementData(attrStatementBeans);
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            SAMLCallback callback;
            if (callbacks[i] instanceof SAMLCallback) {
                callback = (SAMLCallback)callbacks[i];
                callback.setSamlVersion(Version.SAML_20);
                callback.setIssuer(this.issuer);
                if (this.conditions != null) {
                    callback.setConditions(this.conditions);
                }
            } else {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
            SubjectBean subjectBean = new SubjectBean(this.subject.getNameID().getValue(), this.subject.getNameID().getNameQualifier(), this.confirmationMethod);
            subjectBean.setSubjectNameIDFormat(this.subject.getNameID().getFormat());
            subjectBean.setSubjectConfirmationData(this.subjectConfirmationData);
            callback.setSubject(subjectBean);
            this.createAndSetStatement(callback);
        }
    }

    public void setSubjectConfirmationData(SubjectConfirmationDataBean subjectConfirmationData) {
        this.subjectConfirmationData = subjectConfirmationData;
    }

    public void setConditions(ConditionsBean conditionsBean) {
        this.conditions = conditionsBean;
    }

    public void setConfirmationMethod(String confMethod) {
        this.confirmationMethod = confMethod;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public List<AttributeStatement> getAttributeStatements() {
        return this.attributeStatements;
    }

    public void setAttributeStatements(List<AttributeStatement> attributeStatements) {
        this.attributeStatements = attributeStatements;
    }
}

