/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.rest;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.fediz.service.idp.domain.TrustedIdp;
import org.apache.cxf.fediz.service.idp.rest.TrustedIdpService;
import org.apache.cxf.fediz.service.idp.rest.TrustedIdps;
import org.apache.cxf.fediz.service.idp.service.TrustedIdpDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TrustedIdpServiceImpl
implements TrustedIdpService {
    private static final Logger LOG = LoggerFactory.getLogger(TrustedIdpServiceImpl.class);
    @Autowired
    private TrustedIdpDAO trustedIdpDAO;

    public Response updateTrustedIDP(UriInfo ui, String realm, TrustedIdp trustedIdp) {
        if (!realm.equals(trustedIdp.getRealm().toString())) {
            throw new BadRequestException();
        }
        this.trustedIdpDAO.updateTrustedIDP(realm, trustedIdp);
        return Response.noContent().build();
    }

    public TrustedIdps getTrustedIDPs(int start, int size, UriInfo uriInfo) {
        List trustedIdps = this.trustedIdpDAO.getTrustedIDPs(start, size);
        TrustedIdps list = new TrustedIdps();
        list.setTrustedIDPs((Collection)trustedIdps);
        return list;
    }

    public TrustedIdp getTrustedIDP(String realm) {
        return this.trustedIdpDAO.getTrustedIDP(realm);
    }

    public Response addTrustedIDP(UriInfo ui, TrustedIdp trustedIDP) {
        LOG.info("add Trusted IDP config");
        TrustedIdp createdTrustedIdp = this.trustedIdpDAO.addTrustedIDP(trustedIDP);
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)ui.getRequestUri());
        uriBuilder.path("{index}");
        URI location = uriBuilder.build(new Object[]{createdTrustedIdp.getRealm()});
        return Response.created((URI)location).entity((Object)trustedIDP).build();
    }

    public Response deleteTrustedIDP(String realm) {
        this.trustedIdpDAO.deleteTrustedIDP(realm);
        return Response.noContent().build();
    }
}

