/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.rest;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.fediz.service.idp.domain.Entitlement;
import org.apache.cxf.fediz.service.idp.domain.Role;
import org.apache.cxf.fediz.service.idp.rest.RoleService;
import org.apache.cxf.fediz.service.idp.rest.Roles;
import org.apache.cxf.fediz.service.idp.service.EntitlementDAO;
import org.apache.cxf.fediz.service.idp.service.RoleDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RoleServiceImpl
implements RoleService {
    private static final Logger LOG = LoggerFactory.getLogger(RoleServiceImpl.class);
    @Autowired
    private RoleDAO roleDAO;
    @Autowired
    private EntitlementDAO entitlementDAO;

    public Roles getRoles(int start, int size, List<String> expand, UriInfo uriInfo) {
        List roles = this.roleDAO.getRoles(start, size, expand);
        Roles list = new Roles();
        list.setRoles((Collection)roles);
        return list;
    }

    public Role getRole(String name, List<String> expand) {
        Role role = this.roleDAO.getRole(name, expand);
        if (role == null) {
            throw new NotFoundException();
        }
        return role;
    }

    public Response addRole(UriInfo ui, Role role) {
        if (role.getEntitlements() != null && role.getEntitlements().size() > 0) {
            LOG.warn("Role resource contains sub resource 'entitlements'");
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        Role createdRole = this.roleDAO.addRole(role);
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)ui.getRequestUri());
        uriBuilder.path("{index}");
        URI location = uriBuilder.build(new Object[]{createdRole.getName()});
        LOG.debug("Role '" + role.getName() + "' added");
        return Response.created((URI)location).entity((Object)role).build();
    }

    public Response updateRole(UriInfo ui, String name, Role role) {
        if (!name.equals(role.getName().toString())) {
            throw new BadRequestException();
        }
        if (role.getEntitlements() != null && role.getEntitlements().size() > 0) {
            LOG.warn("Role resource contains sub resource 'entitlements'");
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        this.roleDAO.updateRole(name, role);
        LOG.debug("Role '" + role.getName() + "' updated");
        return Response.noContent().build();
    }

    public Response deleteRole(String name) {
        this.roleDAO.deleteRole(name);
        LOG.debug("Role '" + name + "' deleted");
        return Response.noContent().build();
    }

    public Response addEntitlementToRole(UriInfo ui, String name, Entitlement entitlement) {
        Role role = this.roleDAO.getRole(name, null);
        Entitlement foundEntitlement = this.entitlementDAO.getEntitlement(entitlement.getName());
        this.roleDAO.addEntitlementToRole(role, foundEntitlement);
        LOG.debug("Entitlement '" + entitlement.getName() + "' added to Role '" + name + "'");
        return Response.noContent().build();
    }

    public Response removeEntitlementFromRole(UriInfo ui, String name, String entitlementName) {
        Role role = this.roleDAO.getRole(name, null);
        Entitlement entitlement = this.entitlementDAO.getEntitlement(entitlementName);
        this.roleDAO.removeEntitlementFromRole(role, entitlement);
        LOG.debug("Entitlement '" + entitlementName + "' removed from Role '" + name + "'");
        return Response.noContent().build();
    }
}

