/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.rest;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.fediz.service.idp.domain.Entitlement;
import org.apache.cxf.fediz.service.idp.domain.Role;
import org.apache.cxf.fediz.service.idp.rest.Roles;
import org.springframework.security.access.prepost.PreAuthorize;

@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@Path(value="roles")
public interface RoleService {
    @GET
    @PreAuthorize(value="hasRole('ROLE_LIST')")
    public Roles getRoles(@QueryParam(value="start") int var1, @QueryParam(value="size") @DefaultValue(value="2") int var2, @QueryParam(value="expand") @DefaultValue(value="all") List<String> var3, @Context UriInfo var4);

    @GET
    @Path(value="{name}")
    @PreAuthorize(value="hasRole('ROLE_CREATE')")
    public Role getRole(@PathParam(value="name") String var1, @QueryParam(value="expand") @DefaultValue(value="all") List<String> var2);

    @POST
    @PreAuthorize(value="hasRole('ROLE_CREATE')")
    public Response addRole(@Context UriInfo var1, Role var2);

    @PUT
    @Path(value="{name}")
    @PreAuthorize(value="hasRole('ROLE_UPDATE')")
    public Response updateRole(@Context UriInfo var1, @PathParam(value="name") String var2, Role var3);

    @DELETE
    @Path(value="{name}")
    @PreAuthorize(value="hasRole('ROLE_DELETE')")
    public Response deleteRole(@PathParam(value="name") String var1);

    @POST
    @Path(value="{name}/entitlements")
    @PreAuthorize(value="hasRole('ROLE_UPDATE')")
    public Response addEntitlementToRole(@Context UriInfo var1, @PathParam(value="name") String var2, Entitlement var3);

    @DELETE
    @Path(value="{name}/entitlements/{entitlementName}")
    @PreAuthorize(value="hasRole('ROLE_UPDATE')")
    public Response removeEntitlementFromRole(@Context UriInfo var1, @PathParam(value="name") String var2, @PathParam(value="entitlementName") String var3);
}

