/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.rest;

import javax.validation.ConstraintViolationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.security.access.AccessDeniedException;

@Provider
public class RestServiceExceptionMapper
implements ExceptionMapper<Exception> {
    public static final String APPLICATION_ERROR_CODE = "X-Application-Error-Code";
    public static final String APPLICATION_ERROR_INFO = "X-Application-Error-Info";
    private static final String BASIC_REALM_UNAUTHORIZED = "Basic realm=\"Apache Fediz authentication\"";
    private static final Logger LOG = LoggerFactory.getLogger(RestServiceExceptionMapper.class);

    public Response toResponse(Exception ex) {
        LOG.warn("Exception occured processing REST request: " + ex.getMessage(), (Throwable)ex);
        if (ex instanceof AccessDeniedException) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)BASIC_REALM_UNAUTHORIZED).build();
        }
        if (ex instanceof ConstraintViolationException) {
            ConstraintViolationException cve = (ConstraintViolationException)ex;
            LOG.debug("{}\n{}", (Object)ex.getMessage(), (Object)cve.getConstraintViolations().toString());
            return this.buildResponse(Response.Status.BAD_REQUEST, ex);
        }
        if (ex instanceof DataIntegrityViolationException) {
            return this.buildResponse(Response.Status.CONFLICT, ex);
        }
        if (ex instanceof EmptyResultDataAccessException) {
            return this.buildResponse(Response.Status.NOT_FOUND, ex);
        }
        if (ex instanceof DataRetrievalFailureException) {
            return this.buildResponse(Response.Status.NOT_FOUND, ex);
        }
        return this.buildResponse(Response.Status.INTERNAL_SERVER_ERROR, ex);
    }

    Response buildResponse(Response.Status status, Exception ex) {
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)status);
        return responseBuilder.header(APPLICATION_ERROR_CODE, (Object)ex.getClass().getName()).header(APPLICATION_ERROR_INFO, (Object)ex.getMessage()).status(status).build();
    }
}

