/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.protocols;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.X509Certificate;
import java.util.Collections;
import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.config.TrustManager;
import org.apache.cxf.fediz.core.config.jaxb.AudienceUris;
import org.apache.cxf.fediz.core.config.jaxb.CertificateStores;
import org.apache.cxf.fediz.core.config.jaxb.ContextConfig;
import org.apache.cxf.fediz.core.config.jaxb.FederationProtocolType;
import org.apache.cxf.fediz.core.config.jaxb.KeyStoreType;
import org.apache.cxf.fediz.core.config.jaxb.ProtocolType;
import org.apache.cxf.fediz.core.config.jaxb.TrustManagersType;
import org.apache.cxf.fediz.core.config.jaxb.TrustedIssuerType;
import org.apache.cxf.fediz.core.config.jaxb.TrustedIssuers;
import org.apache.cxf.fediz.core.config.jaxb.ValidationType;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.processor.FederationProcessorImpl;
import org.apache.cxf.fediz.core.processor.FedizRequest;
import org.apache.cxf.fediz.core.processor.FedizResponse;
import org.apache.cxf.fediz.core.util.CertsUtils;
import org.apache.cxf.fediz.service.idp.domain.Idp;
import org.apache.cxf.fediz.service.idp.domain.TrustedIdp;
import org.apache.cxf.fediz.service.idp.protocols.AbstractTrustedIdpProtocolHandler;
import org.apache.cxf.fediz.service.idp.util.WebUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.wss4j.common.crypto.CertificateStore;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.xml.security.stax.impl.util.IDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.webflow.execution.RequestContext;
import org.w3c.dom.Element;

@Component
public class TrustedIdpWSFedProtocolHandler
extends AbstractTrustedIdpProtocolHandler {
    public static final String HOME_REALM_PROPAGATION = "home.realm.propagation";
    public static final String PROTOCOL = "http://docs.oasis-open.org/wsfed/federation/200706";
    private static final Logger LOG = LoggerFactory.getLogger(TrustedIdpWSFedProtocolHandler.class);

    public String getProtocol() {
        return PROTOCOL;
    }

    public URL mapSignInRequest(RequestContext context, Idp idp, TrustedIdp trustedIdp) {
        try {
            String wfresh;
            StringBuilder sb = new StringBuilder();
            sb.append(trustedIdp.getUrl());
            sb.append("?").append("wa").append('=');
            sb.append("wsignin1.0");
            sb.append("&").append("wtrealm").append('=');
            sb.append(URLEncoder.encode(idp.getRealm(), "UTF-8"));
            sb.append("&").append("wreply").append('=');
            sb.append(URLEncoder.encode(idp.getIdpUrl().toString(), "UTF-8"));
            if (this.isBooleanPropertyConfigured(trustedIdp, HOME_REALM_PROPAGATION, true)) {
                sb.append("&").append("whr").append('=');
                sb.append(trustedIdp.getRealm());
            }
            if ((wfresh = context.getFlowScope().getString("wfresh")) != null) {
                sb.append("&").append("wfresh").append('=');
                sb.append(URLEncoder.encode(wfresh, "UTF-8"));
            }
            String wctx = context.getFlowScope().getString("trusted_idp_context");
            sb.append("&").append("wctx").append('=');
            sb.append(wctx);
            return new URL(sb.toString());
        }
        catch (MalformedURLException ex) {
            LOG.error("Invalid Redirect URL for Trusted Idp", (Throwable)ex);
            throw new IllegalStateException("Invalid Redirect URL for Trusted Idp");
        }
        catch (UnsupportedEncodingException ex) {
            LOG.error("Invalid Redirect URL for Trusted Idp", (Throwable)ex);
            throw new IllegalStateException("Invalid Redirect URL for Trusted Idp");
        }
    }

    public SecurityToken mapSignInResponse(RequestContext context, Idp idp, TrustedIdp trustedIdp) {
        try {
            String whr = (String)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"whr");
            if (whr == null) {
                LOG.warn("Home realm is null");
                throw new IllegalStateException("Home realm is null");
            }
            String wresult = (String)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"wresult");
            if (wresult == null) {
                LOG.warn("Parameter wresult not found");
                throw new IllegalStateException("No security token issued");
            }
            FedizContext fedContext = this.getFedizContext(idp, trustedIdp);
            FedizRequest wfReq = new FedizRequest();
            wfReq.setAction("wsignin1.0");
            wfReq.setResponseToken(wresult);
            FederationProcessorImpl wfProc = new FederationProcessorImpl();
            FedizResponse wfResp = wfProc.processRequest(wfReq, fedContext);
            fedContext.close();
            Element e = wfResp.getToken();
            String id = IDGenerator.generateID((String)"_");
            SecurityToken idpToken = new SecurityToken(id, wfResp.getTokenCreated(), wfResp.getTokenExpires());
            idpToken.setToken(e);
            LOG.info("[IDP_TOKEN={}] for user '{}' created from [RP_TOKEN={}] issued by home realm [{}/{}]", new Object[]{id, wfResp.getUsername(), wfResp.getUniqueTokenId(), whr, wfResp.getIssuer()});
            LOG.debug("Created date={}", (Object)wfResp.getTokenCreated());
            LOG.debug("Expired date={}", (Object)wfResp.getTokenExpires());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Validated 'wresult' : " + System.getProperty("line.separator") + wresult);
            }
            return idpToken;
        }
        catch (IllegalStateException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.warn("Unexpected exception occured", (Throwable)ex);
            throw new IllegalStateException("Unexpected exception occured: " + ex.getMessage());
        }
    }

    private FedizContext getFedizContext(Idp idpConfig, TrustedIdp trustedIdpConfig) throws ProcessingException {
        boolean isCertificateLocation;
        ContextConfig config = new ContextConfig();
        config.setName("whatever");
        String certificate = trustedIdpConfig.getCertificate();
        boolean bl = isCertificateLocation = !certificate.startsWith("-----BEGIN CERTIFICATE");
        if (isCertificateLocation) {
            CertificateStores certStores = new CertificateStores();
            TrustManagersType tm0 = new TrustManagersType();
            KeyStoreType ks0 = new KeyStoreType();
            ks0.setType("PEM");
            ks0.setFile(trustedIdpConfig.getCertificate());
            tm0.setKeyStore(ks0);
            certStores.getTrustManager().add(tm0);
            config.setCertificateStores(certStores);
        }
        TrustedIssuers trustedIssuers = new TrustedIssuers();
        TrustedIssuerType ti0 = new TrustedIssuerType();
        ti0.setCertificateValidation(ValidationType.PEER_TRUST);
        ti0.setName(trustedIdpConfig.getName());
        trustedIssuers.getIssuer().add(ti0);
        config.setTrustedIssuers(trustedIssuers);
        FederationProtocolType protocol = new FederationProtocolType();
        config.setProtocol((ProtocolType)protocol);
        AudienceUris audienceUris = new AudienceUris();
        audienceUris.getAudienceItem().add(idpConfig.getRealm());
        config.setAudienceUris(audienceUris);
        FedizContext fedContext = new FedizContext(config);
        if (!isCertificateLocation) {
            X509Certificate cert;
            CertificateStore cs = null;
            try {
                cert = CertsUtils.parseX509Certificate((String)trustedIdpConfig.getCertificate());
            }
            catch (Exception ex) {
                LOG.error("Failed to parse trusted certificate", (Throwable)ex);
                throw new ProcessingException("Failed to parse trusted certificate");
            }
            cs = new CertificateStore(Collections.singletonList(cert).toArray(new X509Certificate[0]));
            TrustManager tm = new TrustManager((Crypto)cs);
            fedContext.getCertificateStores().add(tm);
        }
        fedContext.init();
        return fedContext;
    }
}

