/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.protocols;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.fediz.service.idp.protocols.ProtocolController;
import org.apache.cxf.fediz.service.idp.spi.TrustedIdpProtocolHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TrustedIdpProtocolControllerImpl
implements ProtocolController<TrustedIdpProtocolHandler> {
    private static final Logger LOG = LoggerFactory.getLogger(TrustedIdpProtocolControllerImpl.class);
    @Autowired
    private List<TrustedIdpProtocolHandler> protocolHandlers;

    public TrustedIdpProtocolHandler getProtocolHandler(String protocol) {
        for (TrustedIdpProtocolHandler protocolHandler : this.protocolHandlers) {
            if (!protocolHandler.getProtocol().equals(protocol)) continue;
            return protocolHandler;
        }
        LOG.warn("No protocol handler found for {}", (Object)protocol);
        return null;
    }

    public List<String> getProtocols() {
        ArrayList<String> protocols = new ArrayList<String>();
        for (TrustedIdpProtocolHandler protocolHandler : this.protocolHandlers) {
            protocols.add(protocolHandler.getProtocol());
        }
        return Collections.unmodifiableList(protocols);
    }
}

