/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.protocols;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.util.CertsUtils;
import org.apache.cxf.fediz.core.util.DOMUtils;
import org.apache.cxf.fediz.service.idp.domain.Idp;
import org.apache.cxf.fediz.service.idp.domain.TrustedIdp;
import org.apache.cxf.fediz.service.idp.protocols.AbstractTrustedIdpOAuth2ProtocolHandler;
import org.apache.cxf.fediz.service.idp.util.WebUtils;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.rs.security.jose.jaxrs.JsonWebKeysProvider;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.jose.jwt.JwtUtils;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.provider.OAuthJSONProvider;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.webflow.execution.RequestContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Component
public class TrustedIdpOIDCProtocolHandler
extends AbstractTrustedIdpOAuth2ProtocolHandler {
    public static final String SIGNATURE_ALGORITHM = "signature.algorithm";
    public static final String SUBJECT_CLAIM = "subject.claim";
    public static final String SCOPE = "scope";
    public static final String JWKS_URI = "jwks.uri";
    public static final String PROTOCOL = "openid-connect-1.0";
    private static final Logger LOG = LoggerFactory.getLogger(TrustedIdpOIDCProtocolHandler.class);

    public String getProtocol() {
        return PROTOCOL;
    }

    public SecurityToken mapSignInResponse(RequestContext context, Idp idp, TrustedIdp trustedIdp) {
        String code = (String)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"code");
        if (code != null && !code.isEmpty()) {
            String tokenEndpoint = this.getProperty(trustedIdp, "token.endpoint");
            if (tokenEndpoint == null || tokenEndpoint.isEmpty()) {
                LOG.warn("A TOKEN_ENDPOINT must be configured to use the OIDCProtocolHandler");
                throw new IllegalStateException("No TOKEN_ENDPOINT specified");
            }
            String clientId = this.getProperty(trustedIdp, "client.id");
            String clientSecret = this.getProperty(trustedIdp, "client.secret");
            if (clientSecret == null || clientSecret.isEmpty()) {
                LOG.warn("A CLIENT_SECRET must be configured to use the OIDCProtocolHandler");
                throw new IllegalStateException("No CLIENT_SECRET specified");
            }
            ArrayList<OAuthJSONProvider> providers = new ArrayList<OAuthJSONProvider>();
            providers.add(new OAuthJSONProvider());
            WebClient client = WebClient.create((String)tokenEndpoint, providers, (String)clientId, (String)clientSecret, (String)"cxf-tls.xml");
            ClientConfiguration config = WebClient.getConfig((Object)client);
            if (LOG.isDebugEnabled()) {
                config.getOutInterceptors().add(new LoggingOutInterceptor());
                config.getInInterceptors().add(new LoggingInInterceptor());
            }
            client.type("application/x-www-form-urlencoded").accept(new String[]{"application/json"});
            Form form = new Form();
            form.param("grant_type", "authorization_code");
            form.param("code", code);
            form.param("client_id", clientId);
            form.param("redirect_uri", idp.getIdpUrl().toString());
            Response response = client.post((Object)form);
            ClientAccessToken accessToken = (ClientAccessToken)response.readEntity(ClientAccessToken.class);
            String idToken = (String)accessToken.getParameters().get("id_token");
            if (idToken == null) {
                LOG.warn("No IdToken received from the OIDC IdP");
                return null;
            }
            try {
                String whr = (String)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"whr");
                if (whr == null) {
                    LOG.warn("Home realm is null");
                    throw new IllegalStateException("Home realm is null");
                }
                JwsJwtCompactConsumer jwtConsumer = new JwsJwtCompactConsumer(idToken);
                JwtToken jwt = jwtConsumer.getJwtToken();
                if (jwt != null && jwt.getClaims() != null && LOG.isDebugEnabled()) {
                    LOG.debug("Received Claims:");
                    for (Map.Entry claim : jwt.getClaims().asMap().entrySet()) {
                        LOG.debug((String)claim.getKey() + ": " + claim.getValue());
                    }
                }
                if (jwt != null && jwt.getJwsHeaders() != null && LOG.isDebugEnabled()) {
                    LOG.debug("Received JWS Headers:");
                    for (Map.Entry header : jwt.getJwsHeaders().asMap().entrySet()) {
                        LOG.debug((String)header.getKey() + ": " + header.getValue());
                    }
                }
                if (!this.validateSignature(trustedIdp, jwtConsumer)) {
                    LOG.warn("Signature does not validate");
                    return null;
                }
                this.validateToken(jwt, clientId);
                Date created = new Date((Long)jwt.getClaim("iat") * 1000L);
                Date notBefore = null;
                if (jwt.getClaim("nbf") != null) {
                    notBefore = new Date((Long)jwt.getClaim("nbf") * 1000L);
                }
                Date expires = new Date((Long)jwt.getClaim("exp") * 1000L);
                String subjectName = this.getProperty(trustedIdp, SUBJECT_CLAIM);
                LOG.debug("Trying to extract subject name using the claim name {}", (Object)subjectName);
                if (subjectName == null || jwt.getClaim(subjectName) == null) {
                    LOG.debug("No claim available in the token for {}", (Object)subjectName);
                    subjectName = "preferred_username";
                    LOG.debug("Falling back to use subject claim name {}", (Object)subjectName);
                    if (subjectName == null || jwt.getClaim(subjectName) == null) {
                        subjectName = "sub";
                        LOG.debug("No claim available in the token for preferred_username. Falling back to use {}", (Object)subjectName);
                    }
                }
                SamlAssertionWrapper assertion = this.createSamlAssertion(idp, trustedIdp, (String)jwt.getClaim(subjectName), notBefore, expires);
                Document doc = DOMUtils.createDocument();
                Element token = assertion.toDOM(doc);
                SecurityToken idpToken = new SecurityToken(assertion.getId(), created, expires);
                idpToken.setToken(token);
                LOG.info("[IDP_TOKEN={}] for user '{}' created from [RP_TOKEN={}] issued by home realm [{}/{}]", new Object[]{assertion.getId(), assertion.getSaml2().getSubject().getNameID().getValue(), jwt.getClaim("jti"), whr, jwt.getClaim("iss")});
                LOG.debug("Created date={}", (Object)created);
                LOG.debug("Expired date={}", (Object)expires);
                return idpToken;
            }
            catch (IllegalStateException ex) {
                throw ex;
            }
            catch (Exception ex) {
                LOG.warn("Unexpected exception occured", (Throwable)ex);
                throw new IllegalStateException("Unexpected exception occured: " + ex.getMessage());
            }
        }
        return null;
    }

    protected void validateToken(JwtToken jwt, String clientId) {
        if (jwt.getClaim("iss") == null || jwt.getClaim("sub") == null || jwt.getClaim("aud") == null || jwt.getClaim("exp") == null || jwt.getClaim("iat") == null) {
            LOG.warn("The IdToken is missing a required claim");
            throw new IllegalStateException("The IdToken is missing a required claim");
        }
        boolean match = false;
        for (String audience : jwt.getClaims().getAudiences()) {
            if (!clientId.equals(audience)) continue;
            match = true;
            break;
        }
        if (!match) {
            LOG.warn("The audience of the token does not match this client");
            throw new IllegalStateException("The audience of the token does not match this client");
        }
        JwtUtils.validateTokenClaims((JwtClaims)jwt.getClaims(), (int)300, (int)0, (boolean)false);
    }

    private boolean validateSignature(TrustedIdp trustedIdp, JwsJwtCompactConsumer jwtConsumer) throws CertificateException, WSSecurityException, Base64DecodingException, ProcessingException, IOException {
        String sigAlgo = this.getProperty(trustedIdp, SIGNATURE_ALGORITHM);
        if (sigAlgo == null || sigAlgo.isEmpty()) {
            sigAlgo = "RS256";
        }
        JwtToken jwt = jwtConsumer.getJwtToken();
        String jwksUri = this.getProperty(trustedIdp, JWKS_URI);
        JsonWebKey verifyingKey = null;
        if (jwksUri != null && jwt.getJwsHeaders() != null && jwt.getJwsHeaders().containsHeader("kid")) {
            Response response;
            JsonWebKeys jsonWebKeys;
            String kid = (String)jwt.getJwsHeaders().getHeader("kid");
            LOG.debug("Attemping to retrieve key id {} from uri {}", (Object)kid, (Object)jwksUri);
            ArrayList<JsonWebKeysProvider> jsonKeyProviders = new ArrayList<JsonWebKeysProvider>();
            jsonKeyProviders.add(new JsonWebKeysProvider());
            WebClient client = WebClient.create((String)jwksUri, jsonKeyProviders, (String)"cxf-tls.xml");
            client.accept(new String[]{"application/json"});
            ClientConfiguration config = WebClient.getConfig((Object)client);
            if (LOG.isDebugEnabled()) {
                config.getOutInterceptors().add(new LoggingOutInterceptor());
                config.getInInterceptors().add(new LoggingInInterceptor());
            }
            if ((jsonWebKeys = (JsonWebKeys)(response = client.get()).readEntity(JsonWebKeys.class)) != null) {
                verifyingKey = jsonWebKeys.getKey(kid);
            }
        }
        if (verifyingKey != null) {
            return jwtConsumer.verifySignatureWith(verifyingKey, SignatureAlgorithm.getAlgorithm((String)sigAlgo));
        }
        X509Certificate validatingCert = CertsUtils.parseX509Certificate((String)trustedIdp.getCertificate());
        if (validatingCert != null) {
            return jwtConsumer.verifySignatureWith(validatingCert, SignatureAlgorithm.getAlgorithm((String)sigAlgo));
        }
        LOG.warn("No key supplied to verify the signature of the IdToken");
        return false;
    }

    protected String getScope(TrustedIdp trustedIdp) {
        String scope = this.getProperty(trustedIdp, SCOPE);
        if (scope != null && !(scope = scope.trim()).contains("openid")) {
            scope = "openid " + scope;
        }
        if (scope == null || scope.isEmpty()) {
            scope = "openid";
        }
        return scope;
    }
}

