/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.protocols;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.apache.cxf.fediz.service.idp.domain.Idp;
import org.apache.cxf.fediz.service.idp.domain.TrustedIdp;
import org.apache.cxf.fediz.service.idp.protocols.AbstractTrustedIdpOAuth2ProtocolHandler;
import org.apache.cxf.fediz.service.idp.util.WebUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.json.basic.JsonMapObject;
import org.apache.cxf.jaxrs.provider.json.JsonMapObjectProvider;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.provider.OAuthJSONProvider;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.xml.security.stax.impl.util.IDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.webflow.execution.RequestContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Component
public class TrustedIdpFacebookProtocolHandler
extends AbstractTrustedIdpOAuth2ProtocolHandler {
    public static final String API_ENDPOINT = "api.endpoint";
    public static final String SUBJECT_CLAIM = "subject.claim";
    public static final String PROTOCOL = "facebook-connect";
    private static final Logger LOG = LoggerFactory.getLogger(TrustedIdpFacebookProtocolHandler.class);

    public String getProtocol() {
        return PROTOCOL;
    }

    public SecurityToken mapSignInResponse(RequestContext context, Idp idp, TrustedIdp trustedIdp) {
        String code = (String)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"code");
        if (code != null && !code.isEmpty()) {
            String apiEndpoint;
            String tokenEndpoint = this.getProperty(trustedIdp, "token.endpoint");
            if (tokenEndpoint == null || tokenEndpoint.isEmpty()) {
                tokenEndpoint = "https://graph.facebook.com/v2.6/oauth/access_token";
            }
            if ((apiEndpoint = this.getProperty(trustedIdp, API_ENDPOINT)) == null || apiEndpoint.isEmpty()) {
                apiEndpoint = "https://graph.facebook.com/v2.6";
            }
            String clientId = this.getProperty(trustedIdp, "client.id");
            String clientSecret = this.getProperty(trustedIdp, "client.secret");
            if (clientSecret == null || clientSecret.isEmpty()) {
                LOG.warn("A CLIENT_SECRET must be configured to use the TrustedIdpFacebookProtocolHandler");
                throw new IllegalStateException("No CLIENT_SECRET specified");
            }
            ClientAccessToken accessToken = this.getAccessTokenUsingCode(tokenEndpoint, code, clientId, clientSecret, idp.getIdpUrl().toString());
            if (accessToken == null || accessToken.getTokenKey() == null) {
                LOG.warn("No Access Token received from the Facebook IdP");
                return null;
            }
            String subjectName = this.getSubjectName(apiEndpoint, accessToken.getTokenKey(), trustedIdp);
            try {
                String whr = (String)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"whr");
                if (whr == null) {
                    LOG.warn("Home realm is null");
                    throw new IllegalStateException("Home realm is null");
                }
                Date expires = new Date();
                expires.setTime(expires.getTime() + accessToken.getExpiresIn() * 1000L);
                SecurityToken idpToken = new SecurityToken(IDGenerator.generateID(null), null, expires);
                SamlAssertionWrapper assertion = this.createSamlAssertion(idp, trustedIdp, subjectName, null, expires);
                Document doc = DOMUtils.createDocument();
                Element token = assertion.toDOM(doc);
                idpToken.setToken(token);
                LOG.info("[IDP_TOKEN={}] for user '{}' issued by home realm [{}]", new Object[]{assertion.getId(), assertion.getSaml2().getSubject().getNameID().getValue(), whr});
                LOG.debug("Expired date={}", (Object)expires);
                return idpToken;
            }
            catch (IllegalStateException ex) {
                throw ex;
            }
            catch (Exception ex) {
                LOG.warn("Unexpected exception occured", (Throwable)ex);
                throw new IllegalStateException("Unexpected exception occured: " + ex.getMessage());
            }
        }
        return null;
    }

    private ClientAccessToken getAccessTokenUsingCode(String tokenEndpoint, String code, String clientId, String clientSecret, String redirectURI) {
        ArrayList<OAuthJSONProvider> providers = new ArrayList<OAuthJSONProvider>();
        providers.add(new OAuthJSONProvider());
        WebClient client = WebClient.create((String)tokenEndpoint, providers, (String)"cxf-tls.xml");
        ClientConfiguration config = WebClient.getConfig((Object)client);
        if (LOG.isDebugEnabled()) {
            config.getOutInterceptors().add(new LoggingOutInterceptor());
            config.getInInterceptors().add(new LoggingInInterceptor());
        }
        client.type("application/x-www-form-urlencoded");
        client.accept(new String[]{"application/json"});
        Form form = new Form();
        form.param("grant_type", "authorization_code");
        form.param("code", code);
        form.param("client_id", clientId);
        form.param("redirect_uri", redirectURI);
        form.param("client_secret", clientSecret);
        Response response = client.post((Object)form);
        return (ClientAccessToken)response.readEntity(ClientAccessToken.class);
    }

    private String getSubjectName(String apiEndpoint, String accessToken, TrustedIdp trustedIdp) {
        WebClient client = WebClient.create((String)apiEndpoint, Collections.singletonList(new JsonMapObjectProvider()), (String)"cxf-tls.xml");
        client.path((Object)"/me");
        ClientConfiguration config = WebClient.getConfig((Object)client);
        if (LOG.isDebugEnabled()) {
            config.getOutInterceptors().add(new LoggingOutInterceptor());
            config.getInInterceptors().add(new LoggingInInterceptor());
        }
        client.accept(new String[]{"application/json"});
        client.query("access_token", new Object[]{accessToken});
        String subjectName = this.getProperty(trustedIdp, SUBJECT_CLAIM);
        if (subjectName == null || subjectName.isEmpty()) {
            subjectName = "email";
        }
        client.query("fields", new Object[]{subjectName});
        JsonMapObject mapObject = (JsonMapObject)client.get(JsonMapObject.class);
        String parsedSubjectName = (String)mapObject.getProperty(subjectName);
        if (subjectName.contains("email")) {
            parsedSubjectName = parsedSubjectName.replace("\\u0040", "@");
        }
        return parsedSubjectName;
    }

    protected String getScope(TrustedIdp trustedIdp) {
        String scope = this.getProperty(trustedIdp, "scope");
        if (scope != null) {
            scope = scope.trim();
        }
        if (scope == null || scope.isEmpty()) {
            scope = "email";
        }
        return scope;
    }
}

