/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.protocols;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.fediz.service.idp.protocols.ProtocolController;
import org.apache.cxf.fediz.service.idp.spi.ApplicationProtocolHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationProtocolControllerImpl
implements ProtocolController<ApplicationProtocolHandler> {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationProtocolControllerImpl.class);
    @Autowired
    private List<ApplicationProtocolHandler> protocolHandlers;

    public ApplicationProtocolHandler getProtocolHandler(String protocol) {
        for (ApplicationProtocolHandler protocolHandler : this.protocolHandlers) {
            if (!protocolHandler.equals(protocol)) continue;
            return protocolHandler;
        }
        LOG.warn("No protocol handler found for {}", (Object)protocol);
        return null;
    }

    public List<String> getProtocols() {
        ArrayList<String> protocols = new ArrayList<String>();
        for (ApplicationProtocolHandler protocolHandler : this.protocolHandlers) {
            protocols.add(protocolHandler.getProtocol());
        }
        return Collections.unmodifiableList(protocols);
    }
}

