/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.protocols;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.fediz.core.util.CertsUtils;
import org.apache.cxf.fediz.service.idp.domain.Idp;
import org.apache.cxf.fediz.service.idp.domain.TrustedIdp;
import org.apache.cxf.fediz.service.idp.protocols.AbstractTrustedIdpOAuth2ProtocolHandler;
import org.apache.cxf.fediz.service.idp.protocols.AbstractTrustedIdpProtocolHandler;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.saml.bean.ConditionsBean;
import org.apache.wss4j.common.saml.bean.SubjectBean;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractTrustedIdpOAuth2ProtocolHandler
extends AbstractTrustedIdpProtocolHandler {
    public static final String CLIENT_ID = "client.id";
    public static final String CLIENT_SECRET = "client.secret";
    public static final String TOKEN_ENDPOINT = "token.endpoint";
    public static final String SCOPE = "scope";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTrustedIdpOAuth2ProtocolHandler.class);

    public URL mapSignInRequest(RequestContext context, Idp idp, TrustedIdp trustedIdp) {
        String clientId = this.getProperty(trustedIdp, CLIENT_ID);
        if (clientId == null || clientId.isEmpty()) {
            LOG.warn("A CLIENT_ID must be configured for OAuth 2.0");
            throw new IllegalStateException("No CLIENT_ID specified");
        }
        String scope = this.getScope(trustedIdp);
        LOG.debug("Using scope: {}", (Object)scope);
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(trustedIdp.getUrl());
            sb.append("?");
            sb.append("response_type").append('=');
            sb.append("code");
            sb.append("&");
            sb.append("client_id").append('=');
            sb.append(clientId);
            sb.append("&");
            sb.append("redirect_uri").append('=');
            sb.append(URLEncoder.encode(idp.getIdpUrl().toString(), "UTF-8"));
            sb.append("&");
            sb.append(SCOPE).append('=');
            sb.append(URLEncoder.encode(scope, "UTF-8"));
            String state = context.getFlowScope().getString("trusted_idp_context");
            sb.append("&").append("state").append('=');
            sb.append(state);
            return new URL(sb.toString());
        }
        catch (MalformedURLException ex) {
            LOG.error("Invalid Redirect URL for Trusted Idp", (Throwable)ex);
            throw new IllegalStateException("Invalid Redirect URL for Trusted Idp");
        }
        catch (UnsupportedEncodingException ex) {
            LOG.error("Invalid Redirect URL for Trusted Idp", (Throwable)ex);
            throw new IllegalStateException("Invalid Redirect URL for Trusted Idp");
        }
    }

    protected SamlAssertionWrapper createSamlAssertion(Idp idp, TrustedIdp trustedIdp, String subjectName, Date notBefore, Date expires) throws Exception {
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler(null);
        String issuer = idp.getServiceDisplayName();
        if (issuer == null) {
            issuer = idp.getRealm();
        }
        if (issuer != null) {
            callbackHandler.setIssuer(issuer);
        }
        SubjectBean subjectBean = new SubjectBean(subjectName, "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", "urn:oasis:names:tc:SAML:2.0:cm:bearer");
        callbackHandler.setSubjectBean(subjectBean);
        ConditionsBean conditionsBean = new ConditionsBean();
        conditionsBean.setNotAfter(new DateTime((Object)expires));
        if (notBefore != null) {
            DateTime notBeforeDT = new DateTime((Object)notBefore);
            conditionsBean.setNotBefore(notBeforeDT);
        } else {
            conditionsBean.setNotBefore(new DateTime());
        }
        callbackHandler.setConditionsBean(conditionsBean);
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper assertion = new SamlAssertionWrapper(samlCallback);
        Crypto crypto = CertsUtils.getCryptoFromCertificate((String)idp.getCertificate());
        assertion.signAssertion(crypto.getDefaultX509Identifier(), idp.getCertificatePassword(), crypto, false);
        return assertion;
    }

    abstract String getScope(TrustedIdp var1);
}

