/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.metadata;

import java.security.cert.X509Certificate;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.util.CertsUtils;
import org.apache.cxf.fediz.core.util.SignatureUtils;
import org.apache.cxf.fediz.service.idp.domain.Idp;
import org.apache.cxf.fediz.service.idp.domain.TrustedIdp;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.util.DOM2Writer;
import org.apache.xml.security.stax.impl.util.IDGenerator;
import org.apache.xml.security.utils.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ServiceMetadataWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceMetadataWriter.class);

    public Document getMetaData(Idp config, TrustedIdp serviceConfig) throws ProcessingException {
        try {
            Document result;
            Crypto crypto = CertsUtils.getCryptoFromFile((String)config.getCertificate());
            W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
            writer.writeStartDocument("UTF-8", "1.0");
            String referenceID = IDGenerator.generateID((String)"_");
            writer.writeStartElement("md", "EntityDescriptor", "urn:oasis:names:tc:SAML:2.0:metadata");
            writer.writeAttribute("ID", referenceID);
            String serviceURL = config.getIdpUrl().toString();
            writer.writeAttribute("entityID", config.getRealm());
            writer.writeNamespace("md", "urn:oasis:names:tc:SAML:2.0:metadata");
            writer.writeNamespace("fed", "http://docs.oasis-open.org/wsfed/federation/200706");
            writer.writeNamespace("wsa", "http://www.w3.org/2005/08/addressing");
            writer.writeNamespace("auth", "http://docs.oasis-open.org/wsfed/federation/200706");
            writer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            if ("http://docs.oasis-open.org/wsfed/federation/200706".equals(serviceConfig.getProtocol())) {
                this.writeFederationMetadata((XMLStreamWriter)writer, serviceConfig, serviceURL);
            } else if ("urn:oasis:names:tc:SAML:2.0:profiles:SSO:browser".equals(serviceConfig.getProtocol())) {
                this.writeSAMLMetadata((XMLStreamWriter)writer, serviceConfig, serviceURL, crypto);
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
            if (LOG.isDebugEnabled()) {
                String out = DOM2Writer.nodeToString((Node)writer.getDocument());
                LOG.debug("***************** unsigned ****************");
                LOG.debug(out);
                LOG.debug("***************** unsigned ****************");
            }
            if ((result = SignatureUtils.signMetaInfo((Crypto)crypto, null, (String)config.getCertificatePassword(), (Document)writer.getDocument(), (String)referenceID)) != null) {
                return result;
            }
            throw new RuntimeException("Failed to sign the metadata document: result=null");
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Error creating service metadata information ", (Throwable)e);
            throw new ProcessingException("Error creating service metadata information: " + e.getMessage());
        }
    }

    private void writeFederationMetadata(XMLStreamWriter writer, TrustedIdp config, String serviceURL) throws XMLStreamException {
        writer.writeStartElement("md", "RoleDescriptor", "http://docs.oasis-open.org/wsfed/federation/200706");
        writer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "fed:ApplicationServiceType");
        writer.writeAttribute("protocolSupportEnumeration", "http://docs.oasis-open.org/wsfed/federation/200706");
        writer.writeStartElement("fed", "ApplicationServiceEndpoint", "http://docs.oasis-open.org/wsfed/federation/200706");
        writer.writeStartElement("wsa", "EndpointReference", "http://www.w3.org/2005/08/addressing");
        writer.writeStartElement("wsa", "Address", "http://www.w3.org/2005/08/addressing");
        writer.writeCharacters(serviceURL);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("fed", "TargetScope", "http://docs.oasis-open.org/wsfed/federation/200706");
        writer.writeEndElement();
        writer.writeStartElement("fed", "PassiveRequestorEndpoint", "http://docs.oasis-open.org/wsfed/federation/200706");
        writer.writeStartElement("wsa", "EndpointReference", "http://www.w3.org/2005/08/addressing");
        writer.writeStartElement("wsa", "Address", "http://www.w3.org/2005/08/addressing");
        writer.writeCharacters(serviceURL);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private void writeSAMLMetadata(XMLStreamWriter writer, TrustedIdp config, String serviceURL, Crypto crypto) throws Exception {
        writer.writeStartElement("md", "SPSSODescriptor", "urn:oasis:names:tc:SAML:2.0:metadata");
        boolean signRequest = this.isPropertyConfigured(config, "sign.request", true);
        writer.writeAttribute("AuthnRequestsSigned", Boolean.toString(signRequest));
        writer.writeAttribute("WantAssertionsSigned", "true");
        writer.writeAttribute("protocolSupportEnumeration", "urn:oasis:names:tc:SAML:2.0:protocol");
        writer.writeStartElement("md", "AssertionConsumerService", "urn:oasis:names:tc:SAML:2.0:metadata");
        writer.writeAttribute("Location", serviceURL);
        writer.writeAttribute("index", "0");
        writer.writeAttribute("isDefault", "true");
        writer.writeAttribute("Binding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        writer.writeEndElement();
        if (signRequest) {
            writer.writeStartElement("md", "KeyDescriptor", "urn:oasis:names:tc:SAML:2.0:metadata");
            writer.writeAttribute("use", "signing");
            writer.writeStartElement("ds", "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
            writer.writeNamespace("ds", "http://www.w3.org/2000/09/xmldsig#");
            writer.writeStartElement("ds", "X509Data", "http://www.w3.org/2000/09/xmldsig#");
            writer.writeStartElement("ds", "X509Certificate", "http://www.w3.org/2000/09/xmldsig#");
            String keyAlias = crypto.getDefaultX509Identifier();
            X509Certificate cert = CertsUtils.getX509CertificateFromCrypto((Crypto)crypto, (String)keyAlias);
            if (cert == null) {
                throw new ProcessingException("No signing certs were found to insert into the metadata using name: " + keyAlias);
            }
            byte[] data = cert.getEncoded();
            String encodedCertificate = Base64.encode((byte[])data);
            writer.writeCharacters(encodedCertificate);
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private boolean isPropertyConfigured(TrustedIdp trustedIdp, String property, boolean defaultValue) {
        Map parameters = trustedIdp.getParameters();
        if (parameters != null && parameters.containsKey(property)) {
            return Boolean.parseBoolean((String)parameters.get(property));
        }
        return defaultValue;
    }
}

