/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.metadata;

import java.security.cert.X509Certificate;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.fediz.core.util.CertsUtils;
import org.apache.cxf.fediz.core.util.SignatureUtils;
import org.apache.cxf.fediz.service.idp.domain.Claim;
import org.apache.cxf.fediz.service.idp.domain.Idp;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.util.DOM2Writer;
import org.apache.xml.security.stax.impl.util.IDGenerator;
import org.apache.xml.security.utils.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class IdpMetadataWriter {
    private static final Logger LOG = LoggerFactory.getLogger(IdpMetadataWriter.class);

    public Document getMetaData(Idp config) throws RuntimeException {
        try {
            Document result;
            Crypto crypto = CertsUtils.getCryptoFromFile((String)config.getCertificate());
            W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
            writer.writeStartDocument("UTF-8", "1.0");
            String referenceID = IDGenerator.generateID((String)"_");
            writer.writeStartElement("md", "EntityDescriptor", "urn:oasis:names:tc:SAML:2.0:metadata");
            writer.writeAttribute("ID", referenceID);
            writer.writeAttribute("entityID", config.getIdpUrl().toString());
            writer.writeNamespace("md", "urn:oasis:names:tc:SAML:2.0:metadata");
            writer.writeNamespace("fed", "http://docs.oasis-open.org/wsfed/federation/200706");
            writer.writeNamespace("wsa", "http://www.w3.org/2005/08/addressing");
            writer.writeNamespace("auth", "http://docs.oasis-open.org/wsfed/federation/200706");
            writer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.writeFederationMetadata((XMLStreamWriter)writer, config, crypto);
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
            if (LOG.isDebugEnabled()) {
                String out = DOM2Writer.nodeToString((Node)writer.getDocument());
                LOG.debug("***************** unsigned ****************");
                LOG.debug(out);
                LOG.debug("***************** unsigned ****************");
            }
            if ((result = SignatureUtils.signMetaInfo((Crypto)crypto, null, (String)config.getCertificatePassword(), (Document)writer.getDocument(), (String)referenceID)) != null) {
                return result;
            }
            throw new RuntimeException("Failed to sign the metadata document: result=null");
        }
        catch (Exception e) {
            LOG.error("Error creating service metadata information ", (Throwable)e);
            throw new RuntimeException("Error creating service metadata information: " + e.getMessage());
        }
    }

    private void writeFederationMetadata(XMLStreamWriter writer, Idp config, Crypto crypto) throws XMLStreamException {
        writer.writeStartElement("md", "RoleDescriptor", "http://docs.oasis-open.org/wsfed/federation/200706");
        writer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "fed:SecurityTokenServiceType");
        writer.writeAttribute("protocolSupportEnumeration", "http://docs.oasis-open.org/wsfed/federation/200706");
        if (config.getServiceDescription() != null && config.getServiceDescription().length() > 0) {
            writer.writeAttribute("ServiceDescription", config.getServiceDescription());
        }
        if (config.getServiceDisplayName() != null && config.getServiceDisplayName().length() > 0) {
            writer.writeAttribute("ServiceDisplayName", config.getServiceDisplayName());
        }
        writer.writeStartElement("", "KeyDescriptor", "urn:oasis:names:tc:SAML:2.0:metadata");
        writer.writeAttribute("use", "signing");
        writer.writeStartElement("", "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
        writer.writeStartElement("", "X509Data", "http://www.w3.org/2000/09/xmldsig#");
        writer.writeStartElement("", "X509Certificate", "http://www.w3.org/2000/09/xmldsig#");
        try {
            String keyAlias = crypto.getDefaultX509Identifier();
            X509Certificate cert = CertsUtils.getX509CertificateFromCrypto((Crypto)crypto, (String)keyAlias);
            writer.writeCharacters(Base64.encode((byte[])cert.getEncoded()));
        }
        catch (Exception ex) {
            LOG.error("Failed to add certificate information to metadata. Metadata incomplete", (Throwable)ex);
        }
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("fed", "SecurityTokenServiceEndpoint", "http://docs.oasis-open.org/wsfed/federation/200706");
        writer.writeStartElement("wsa", "EndpointReference", "http://www.w3.org/2005/08/addressing");
        writer.writeStartElement("wsa", "Address", "http://www.w3.org/2005/08/addressing");
        writer.writeCharacters(config.getStsUrl().toString());
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeStartElement("fed", "PassiveRequestorEndpoint", "http://docs.oasis-open.org/wsfed/federation/200706");
        writer.writeStartElement("wsa", "EndpointReference", "http://www.w3.org/2005/08/addressing");
        writer.writeStartElement("wsa", "Address", "http://www.w3.org/2005/08/addressing");
        writer.writeCharacters(config.getIdpUrl().toString());
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        if (config.getClaimTypesOffered() != null && config.getClaimTypesOffered().size() > 0) {
            writer.writeStartElement("fed", "ClaimTypesOffered", "http://docs.oasis-open.org/wsfed/federation/200706");
            for (Claim claim : config.getClaimTypesOffered()) {
                writer.writeStartElement("auth", "ClaimType", "http://docs.oasis-open.org/wsfed/federation/200706");
                writer.writeAttribute("Uri", claim.getClaimType().toString());
                writer.writeAttribute("Optional", "true");
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

