/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.kerberos;

import org.apache.cxf.fediz.core.util.DOMUtils;
import org.apache.cxf.ws.security.kerberos.KerberosClient;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.message.token.KerberosSecurity;
import org.apache.xml.security.utils.Base64;

public class PassThroughKerberosClient
extends KerberosClient {
    private byte[] token;

    public SecurityToken requestSecurityToken() throws Exception {
        KerberosSecurity bst = new KerberosSecurity(DOMUtils.createDocument());
        bst.setValueType("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ");
        bst.setToken(this.token);
        bst.addWSUNamespace();
        bst.setID(WSSConfig.getNewInstance().getIdAllocator().createSecureId("BST-", (Object)bst));
        SecurityToken securityToken = new SecurityToken(bst.getID());
        securityToken.setToken(bst.getElement());
        securityToken.setWsuId(bst.getID());
        securityToken.setData(bst.getToken());
        String sha1 = Base64.encode((byte[])KeyUtils.generateDigest((byte[])bst.getToken()));
        securityToken.setSHA1(sha1);
        securityToken.setTokenType(bst.getValueType());
        return securityToken;
    }

    public byte[] getToken() {
        return this.token;
    }

    public void setToken(byte[] token) {
        this.token = token;
    }
}

