/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.beans.samlsso;

import java.io.IOException;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.service.idp.domain.Idp;
import org.apache.cxf.fediz.service.idp.samlsso.SAML2PResponseComponentBuilder;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.rs.security.saml.DeflateEncoderDecoder;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.apache.wss4j.common.util.DOM2Writer;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.webflow.execution.RequestContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Component
public class SamlResponseErrorCreator {
    private static final Logger LOG = LoggerFactory.getLogger(SamlResponseErrorCreator.class);
    private boolean supportDeflateEncoding;

    public String createSAMLResponse(RequestContext context, boolean requestor, Idp idp, String requestID) throws ProcessingException {
        Document doc = DOMUtils.newDocument();
        String statusValue = "urn:oasis:names:tc:SAML:2.0:status:Responder";
        if (requestor) {
            statusValue = "urn:oasis:names:tc:SAML:2.0:status:Requester";
        }
        Status status = SAML2PResponseComponentBuilder.createStatus((String)statusValue, null);
        Response response = SAML2PResponseComponentBuilder.createSAMLResponse((String)requestID, (String)idp.getRealm(), (Status)status);
        try {
            Element policyElement = OpenSAMLUtil.toDom((XMLObject)response, (Document)doc);
            doc.appendChild(policyElement);
            Element responseElement = policyElement;
            return this.encodeResponse(responseElement);
        }
        catch (Exception e) {
            LOG.warn("Error marshalling SAML Token: {}", (Object)e.getMessage());
            throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
        }
    }

    protected String encodeResponse(Element response) throws IOException {
        String responseMessage = DOM2Writer.nodeToString((Node)response);
        LOG.debug("Created Response: {}", (Object)responseMessage);
        if (this.supportDeflateEncoding) {
            DeflateEncoderDecoder encoder = new DeflateEncoderDecoder();
            byte[] deflatedBytes = encoder.deflateToken(responseMessage.getBytes("UTF-8"));
            return Base64Utility.encode((byte[])deflatedBytes);
        }
        return Base64Utility.encode((byte[])responseMessage.getBytes());
    }

    public boolean isSupportDeflateEncoding() {
        return this.supportDeflateEncoding;
    }

    public void setSupportDeflateEncoding(boolean supportDeflateEncoding) {
        this.supportDeflateEncoding = supportDeflateEncoding;
    }
}

