/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.beans.samlsso;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.util.CertsUtils;
import org.apache.cxf.fediz.service.idp.domain.Idp;
import org.apache.cxf.fediz.service.idp.samlsso.SAML2CallbackHandler;
import org.apache.cxf.fediz.service.idp.samlsso.SAML2PResponseComponentBuilder;
import org.apache.cxf.fediz.service.idp.util.WebUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.rs.security.saml.DeflateEncoderDecoder;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.saml.bean.AudienceRestrictionBean;
import org.apache.wss4j.common.saml.bean.ConditionsBean;
import org.apache.wss4j.common.saml.bean.SubjectConfirmationDataBean;
import org.apache.wss4j.common.util.DOM2Writer;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.webflow.execution.RequestContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Component
public class SamlResponseCreator {
    private static final Logger LOG = LoggerFactory.getLogger(SamlResponseCreator.class);
    private boolean supportDeflateEncoding;

    public String createSAMLResponse(RequestContext context, Idp idp, Element rpToken, String consumerURL, String requestId, String requestIssuer) throws ProcessingException {
        List samlTokens = DOMUtils.findAllElementsByTagNameNS((Element)rpToken, (String)"urn:oasis:names:tc:SAML:2.0:assertion", (String)"Assertion");
        if (samlTokens.isEmpty() || samlTokens.size() != 1) {
            throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
        }
        try {
            SamlAssertionWrapper wrapper = new SamlAssertionWrapper((Element)samlTokens.get(0));
            if (wrapper.getSaml2() == null) {
                throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
            }
            String remoteAddr = WebUtils.getHttpServletRequest((RequestContext)context).getRemoteAddr();
            Assertion saml2Assertion = this.createSAML2Assertion(context, idp, wrapper, requestId, requestIssuer, remoteAddr, consumerURL);
            Element response = this.createResponse(idp, requestId, saml2Assertion);
            return this.encodeResponse(response);
        }
        catch (Exception ex) {
            LOG.warn("Error marshalling SAML Token: {}", (Object)ex.getMessage());
            throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
        }
    }

    private Assertion createSAML2Assertion(RequestContext context, Idp idp, SamlAssertionWrapper receivedToken, String requestID, String requestIssuer, String remoteAddr, String racs) throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setIssuer(idp.getRealm());
        callbackHandler.setSubject(receivedToken.getSaml2().getSubject());
        AuthnRequest authnRequest = (AuthnRequest)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"saml_authn_request");
        if (authnRequest.getSubject() != null && authnRequest.getSubject().getNameID() != null && receivedToken.getSaml2().getSubject().getNameID() != null) {
            NameID receivedNameId = authnRequest.getSubject().getNameID();
            NameID issuedNameId = receivedToken.getSaml2().getSubject().getNameID();
            if (!receivedNameId.getValue().equals(issuedNameId.getValue())) {
                LOG.debug("Received NameID value of {} does not match issued value {}", (Object)receivedNameId.getValue(), (Object)issuedNameId.getValue());
                throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
            }
        }
        SubjectConfirmationDataBean subjectConfirmationData = new SubjectConfirmationDataBean();
        subjectConfirmationData.setAddress(remoteAddr);
        subjectConfirmationData.setInResponseTo(requestID);
        subjectConfirmationData.setNotAfter(new DateTime().plusMinutes(5));
        subjectConfirmationData.setRecipient(racs);
        callbackHandler.setSubjectConfirmationData(subjectConfirmationData);
        ConditionsBean conditions = new ConditionsBean();
        conditions.setTokenPeriodMinutes(5);
        AudienceRestrictionBean audienceRestriction = new AudienceRestrictionBean();
        audienceRestriction.setAudienceURIs(Collections.singletonList(requestIssuer));
        conditions.setAudienceRestrictions(Collections.singletonList(audienceRestriction));
        callbackHandler.setConditions(conditions);
        callbackHandler.setAttributeStatements(receivedToken.getSaml2().getAttributeStatements());
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper assertion = new SamlAssertionWrapper(samlCallback);
        Crypto issuerCrypto = CertsUtils.getCryptoFromCertificate((String)idp.getCertificate());
        assertion.signAssertion(issuerCrypto.getDefaultX509Identifier(), idp.getCertificatePassword(), issuerCrypto, false);
        return assertion.getSaml2();
    }

    protected Element createResponse(Idp idp, String requestID, Assertion assertion) throws Exception {
        Document doc = DOMUtils.newDocument();
        Status status = SAML2PResponseComponentBuilder.createStatus((String)"urn:oasis:names:tc:SAML:2.0:status:Success", null);
        Response response = SAML2PResponseComponentBuilder.createSAMLResponse((String)requestID, (String)idp.getRealm(), (Status)status);
        response.getAssertions().add(assertion);
        Element policyElement = OpenSAMLUtil.toDom((XMLObject)response, (Document)doc);
        doc.appendChild(policyElement);
        return policyElement;
    }

    protected String encodeResponse(Element response) throws IOException {
        String responseMessage = DOM2Writer.nodeToString((Node)response);
        LOG.debug("Created Response: {}", (Object)responseMessage);
        if (this.supportDeflateEncoding) {
            DeflateEncoderDecoder encoder = new DeflateEncoderDecoder();
            byte[] deflatedBytes = encoder.deflateToken(responseMessage.getBytes("UTF-8"));
            return Base64Utility.encode((byte[])deflatedBytes);
        }
        return Base64Utility.encode((byte[])responseMessage.getBytes());
    }

    public boolean isSupportDeflateEncoding() {
        return this.supportDeflateEncoding;
    }

    public void setSupportDeflateEncoding(boolean supportDeflateEncoding) {
        this.supportDeflateEncoding = supportDeflateEncoding;
    }
}

