/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.beans.samlsso;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.cxf.fediz.service.idp.domain.Idp;
import org.apache.cxf.fediz.service.idp.util.WebUtils;
import org.springframework.stereotype.Component;
import org.springframework.webflow.execution.RequestContext;

@Component
public class LocalRedirectCreator {
    public String createRedirectURL(RequestContext context, Idp idp) throws UnsupportedEncodingException {
        StringBuilder redirectURL = new StringBuilder();
        redirectURL.append(idp.getIdpUrl().toString()).append("?");
        String relayState = (String)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"RelayState");
        redirectURL.append("RelayState=").append(relayState).append("&");
        String samlRequest = (String)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"SAMLRequest");
        redirectURL.append("SAMLRequest=").append(URLEncoder.encode(samlRequest, "UTF-8"));
        String signature = (String)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"Signature");
        if (signature != null) {
            redirectURL.append("&");
            redirectURL.append("Signature=").append(URLEncoder.encode(signature, "UTF-8"));
        }
        return redirectURL.toString();
    }
}

