/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.beans.samlsso;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.Collections;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.util.CertsUtils;
import org.apache.cxf.fediz.service.idp.domain.Application;
import org.apache.cxf.fediz.service.idp.domain.Idp;
import org.apache.cxf.fediz.service.idp.util.WebUtils;
import org.apache.wss4j.common.crypto.CertificateStore;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SAMLKeyInfoProcessor;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.saml.WSSSAMLKeyInfoProcessor;
import org.apache.wss4j.dom.validate.SignatureTrustValidator;
import org.apache.xml.security.utils.Base64;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.webflow.execution.RequestContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Component
public class AuthnRequestValidator {
    private static final Logger LOG = LoggerFactory.getLogger(AuthnRequestValidator.class);
    private boolean requireSignature = true;

    public void validateAuthnRequest(RequestContext context, Idp idp, String signature, String relayState, String samlRequest, String realm) throws Exception {
        AuthnRequest authnRequest = (AuthnRequest)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"saml_authn_request");
        if (authnRequest == null) {
            throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
        }
        this.validateSignature(context, authnRequest, idp, signature, relayState, samlRequest, realm);
        if (authnRequest.getIssuer() == null) {
            LOG.debug("No Issuer is present in the AuthnRequest");
            throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
        }
        String format = authnRequest.getIssuer().getFormat();
        if (format != null && !"urn:oasis:names:tc:SAML:2.0:nameid-format:entity".equals(format)) {
            LOG.debug("An invalid Format attribute was received: {}", (Object)format);
            throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
        }
        if (authnRequest.getSubject() != null && authnRequest.getSubject().getSubjectConfirmations() != null && !authnRequest.getSubject().getSubjectConfirmations().isEmpty()) {
            LOG.debug("An invalid SubjectConfirmation Element was received");
            throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
        }
    }

    private void validateSignature(RequestContext context, AuthnRequest authnRequest, Idp idp, String signature, String relayState, String samlRequest, String realm) throws ProcessingException {
        try {
            if (authnRequest.isSigned()) {
                this.checkDestination(context, authnRequest);
                X509Certificate validatingCert = this.getValidatingCertificate(idp, realm);
                CertificateStore issuerCrypto = new CertificateStore(Collections.singletonList(validatingCert).toArray(new X509Certificate[0]));
                this.validateAuthnRequestSignature(authnRequest.getSignature(), (Crypto)issuerCrypto);
            } else if (signature != null) {
                this.checkDestination(context, authnRequest);
                X509Certificate validatingCert = this.getValidatingCertificate(idp, realm);
                Signature sig = Signature.getInstance("SHA1withRSA");
                sig.initVerify(validatingCert);
                String requestToSign = "SAMLRequest=" + URLEncoder.encode(samlRequest, "UTF-8") + "&" + "RelayState" + "=" + relayState + "&" + "SigAlg" + "=" + URLEncoder.encode("http://www.w3.org/2000/09/xmldsig#rsa-sha1", StandardCharsets.UTF_8.name());
                sig.update(requestToSign.getBytes(StandardCharsets.UTF_8));
                if (!sig.verify(Base64.decode((String)signature))) {
                    LOG.debug("Signature validation failed");
                    throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
                }
            } else {
                if (this.requireSignature) {
                    LOG.debug("No signature is present, therefore the request is rejected");
                    throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
                }
                LOG.debug("No signature is present, but this is allowed by configuration");
            }
        }
        catch (Exception ex) {
            LOG.debug("Error validating SAML Signature", (Throwable)ex);
            throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
        }
    }

    private X509Certificate getValidatingCertificate(Idp idp, String realm) throws Exception {
        Application serviceConfig = idp.findApplication(realm);
        if (serviceConfig == null || serviceConfig.getValidatingCertificate() == null) {
            LOG.debug("No validating certificate found for realm {}", (Object)realm);
            throw new ProcessingException(ProcessingException.TYPE.ISSUER_NOT_TRUSTED);
        }
        return CertsUtils.parseX509Certificate((String)serviceConfig.getValidatingCertificate());
    }

    private void checkDestination(RequestContext context, AuthnRequest authnRequest) throws ProcessingException {
        String destination = authnRequest.getDestination();
        LOG.debug("Validating destination: {}", (Object)destination);
        String localAddr = WebUtils.getHttpServletRequest((RequestContext)context).getRequestURL().toString();
        if (destination == null || !localAddr.startsWith(destination)) {
            LOG.debug("The destination {} does not match the local address {}", (Object)destination, (Object)localAddr);
            throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
        }
    }

    private void validateAuthnRequestSignature(org.opensaml.xmlsec.signature.Signature signature, Crypto sigCrypto) throws WSSecurityException {
        RequestData requestData = new RequestData();
        requestData.setSigVerCrypto(sigCrypto);
        WSSConfig wssConfig = WSSConfig.getNewInstance();
        requestData.setWssConfig(wssConfig);
        SAMLKeyInfo samlKeyInfo = null;
        KeyInfo keyInfo = signature.getKeyInfo();
        if (keyInfo != null) {
            try {
                Document doc = signature.getDOM().getOwnerDocument();
                samlKeyInfo = SAMLUtil.getCredentialFromKeyInfo((Element)keyInfo.getDOM(), (SAMLKeyInfoProcessor)new WSSSAMLKeyInfoProcessor(requestData, new WSDocInfo(doc)), (Crypto)sigCrypto);
            }
            catch (WSSecurityException ex) {
                LOG.debug("Error in getting KeyInfo from SAML AuthnRequest: {}", (Object)ex.getMessage(), (Object)ex);
                throw ex;
            }
        }
        if (samlKeyInfo == null) {
            LOG.debug("No KeyInfo supplied in the AuthnRequest signature");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        this.validateSignatureAgainstProfiles(signature, samlKeyInfo);
        org.apache.wss4j.dom.validate.Credential trustCredential = new org.apache.wss4j.dom.validate.Credential();
        trustCredential.setPublicKey(samlKeyInfo.getPublicKey());
        trustCredential.setCertificates(samlKeyInfo.getCerts());
        try {
            SignatureTrustValidator signatureValidator = new SignatureTrustValidator();
            signatureValidator.validate(trustCredential, requestData);
        }
        catch (WSSecurityException e) {
            LOG.debug("Error in validating signature on SAML AuthnRequest: {}", (Object)e.getMessage(), (Object)e);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
    }

    private void validateSignatureAgainstProfiles(org.opensaml.xmlsec.signature.Signature signature, SAMLKeyInfo samlKeyInfo) throws WSSecurityException {
        SAMLSignatureProfileValidator validator = new SAMLSignatureProfileValidator();
        try {
            validator.validate(signature);
        }
        catch (SignatureException ex) {
            LOG.debug("Error in validating the SAML Signature: {}", (Object)ex.getMessage(), (Object)ex);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        BasicX509Credential credential = null;
        if (samlKeyInfo.getCerts() != null) {
            credential = new BasicX509Credential(samlKeyInfo.getCerts()[0]);
        } else if (samlKeyInfo.getPublicKey() != null) {
            credential = new BasicCredential(samlKeyInfo.getPublicKey());
        } else {
            LOG.debug("Can't get X509Certificate or PublicKey to verify signature");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        try {
            SignatureValidator.validate((org.opensaml.xmlsec.signature.Signature)signature, (Credential)credential);
        }
        catch (SignatureException ex) {
            LOG.debug("Error in validating the SAML Signature: {}", (Object)ex.getMessage(), (Object)ex);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
    }

    public boolean isRequireSignature() {
        return this.requireSignature;
    }

    public void setRequireSignature(boolean requireSignature) {
        this.requireSignature = requireSignature;
    }
}

