/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.beans.samlsso;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.service.idp.domain.Idp;
import org.apache.cxf.fediz.service.idp.util.WebUtils;
import org.apache.cxf.rs.security.saml.DeflateEncoderDecoder;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.apache.wss4j.common.util.DOM2Writer;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.webflow.execution.RequestContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Component
public class AuthnRequestParser {
    private static final Logger LOG = LoggerFactory.getLogger(AuthnRequestParser.class);
    private boolean supportDeflateEncoding;

    public void parseSAMLRequest(RequestContext context, Idp idp, String samlRequest) throws ProcessingException {
        LOG.debug("Received SAML Request: {}", (Object)samlRequest);
        AuthnRequest parsedRequest = null;
        if (samlRequest == null) {
            WebUtils.removeAttributeFromFlowScope((RequestContext)context, (String)"saml_authn_request");
        } else {
            parsedRequest = (AuthnRequest)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"saml_authn_request");
            if (parsedRequest == null) {
                try {
                    parsedRequest = this.extractRequest(context, samlRequest);
                    WebUtils.putAttributeInFlowScope((RequestContext)context, (String)"saml_authn_request", (Object)parsedRequest);
                    LOG.debug("SAML Request with id '{}' successfully parsed", (Object)parsedRequest.getID());
                }
                catch (Exception ex) {
                    LOG.warn("Error parsing request: {}", (Object)ex.getMessage());
                }
            }
        }
    }

    public String retrieveRealm(RequestContext context) {
        AuthnRequest authnRequest = (AuthnRequest)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"saml_authn_request");
        if (authnRequest != null && authnRequest.getIssuer() != null) {
            String issuer = authnRequest.getIssuer().getValue();
            LOG.debug("Parsed SAML AuthnRequest Issuer: {}", (Object)issuer);
            return issuer;
        }
        LOG.debug("No AuthnRequest available to be parsed");
        return null;
    }

    public String retrieveConsumerURL(RequestContext context) {
        AuthnRequest authnRequest = (AuthnRequest)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"saml_authn_request");
        if (authnRequest != null && authnRequest.getAssertionConsumerServiceURL() != null) {
            String consumerURL = authnRequest.getAssertionConsumerServiceURL();
            LOG.debug("Parsed SAML AuthnRequest Consumer URL: {}", (Object)consumerURL);
            return consumerURL;
        }
        LOG.debug("No AuthnRequest available to be parsed");
        return null;
    }

    public String retrieveRequestId(RequestContext context) {
        AuthnRequest authnRequest = (AuthnRequest)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"saml_authn_request");
        if (authnRequest != null && authnRequest.getID() != null) {
            String id = authnRequest.getID();
            LOG.debug("Parsed SAML AuthnRequest Id: {}", (Object)id);
            return id;
        }
        LOG.debug("No AuthnRequest available to be parsed");
        return null;
    }

    public String retrieveRequestIssuer(RequestContext context) {
        AuthnRequest authnRequest = (AuthnRequest)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"saml_authn_request");
        if (authnRequest != null && authnRequest.getIssuer() != null) {
            String issuer = authnRequest.getIssuer().getValue();
            LOG.debug("Parsed SAML AuthnRequest Issuer: {}", (Object)issuer);
            return issuer;
        }
        LOG.debug("No AuthnRequest available to be parsed");
        return null;
    }

    public boolean isForceAuthentication(RequestContext context) {
        AuthnRequest authnRequest = (AuthnRequest)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"saml_authn_request");
        if (authnRequest != null) {
            return authnRequest.isForceAuthn();
        }
        LOG.debug("No AuthnRequest available to be parsed");
        return false;
    }

    protected AuthnRequest extractRequest(RequestContext context, String samlRequest) throws Exception {
        byte[] deflatedToken = Base64Utility.decode((String)samlRequest);
        String httpMethod = WebUtils.getHttpServletRequest((RequestContext)context).getMethod();
        InputStream tokenStream = this.supportDeflateEncoding || "GET".equals(httpMethod) ? new DeflateEncoderDecoder().inflateToken(deflatedToken) : new ByteArrayInputStream(deflatedToken);
        Document responseDoc = StaxUtils.read((Reader)new InputStreamReader(tokenStream, "UTF-8"));
        AuthnRequest request = (AuthnRequest)OpenSAMLUtil.fromDom((Element)responseDoc.getDocumentElement());
        if (LOG.isDebugEnabled()) {
            LOG.debug(DOM2Writer.nodeToString((Node)responseDoc));
        }
        return request;
    }

    public boolean isSupportDeflateEncoding() {
        return this.supportDeflateEncoding;
    }

    public void setSupportDeflateEncoding(boolean supportDeflateEncoding) {
        this.supportDeflateEncoding = supportDeflateEncoding;
    }
}

