/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.beans;

import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.webflow.execution.RequestContext;
import org.w3c.dom.Element;

@Component
public class TokenSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(TokenSerializer.class);

    public String serialize(RequestContext context, Element rpToken) {
        if (rpToken != null) {
            StringWriter sw = new StringWriter();
            try {
                Transformer t = TransformerFactory.newInstance().newTransformer();
                t.setOutputProperty("omit-xml-declaration", "yes");
                t.transform(new DOMSource(rpToken), new StreamResult(sw));
            }
            catch (TransformerException te) {
                LOG.warn("nodeToString Transformer Exception");
            }
            String serializedToken = sw.toString();
            return StringEscapeUtils.escapeXml11((String)serializedToken);
        }
        return null;
    }
}

