/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.beans;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.service.idp.domain.Application;
import org.apache.cxf.fediz.service.idp.domain.Idp;
import org.apache.cxf.fediz.service.idp.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.webflow.execution.RequestContext;

@Component
public class SigninParametersCacheAction {
    @Deprecated
    public static final String REALM_URL_MAP = "realmUrlMap";
    public static final String ACTIVE_APPLICATIONS = "realmConfigMap";
    private static final Logger LOG = LoggerFactory.getLogger(SigninParametersCacheAction.class);

    public void store(RequestContext context) {
        HashMap<String, Object> signinParams = new HashMap<String, Object>();
        String uuidKey = UUID.randomUUID().toString();
        Object value = WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"wreply");
        if (value != null) {
            signinParams.put("wreply", value);
        }
        if ((value = WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"wtrealm")) != null) {
            signinParams.put("wtrealm", value);
        }
        if ((value = WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"whr")) != null) {
            signinParams.put("whr", value);
        }
        if ((value = WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"wctx")) != null) {
            signinParams.put("wctx", value);
        }
        WebUtils.putAttributeInExternalContext((RequestContext)context, (String)uuidKey, signinParams);
        LOG.debug("SignIn parameters cached: {}", (Object)((Object)signinParams).toString());
        WebUtils.putAttributeInFlowScope((RequestContext)context, (String)"trusted_idp_context", (Object)uuidKey);
        LOG.info("SignIn parameters cached and context set to [" + uuidKey + "].");
    }

    public void restore(RequestContext context) {
        String uuidKey = (String)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"wctx");
        if (uuidKey == null) {
            uuidKey = (String)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"RelayState");
        }
        if (uuidKey == null) {
            uuidKey = (String)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"state");
        }
        if (uuidKey != null) {
            Map signinParams = (Map)WebUtils.getAttributeFromExternalContext((RequestContext)context, (String)uuidKey);
            if (signinParams != null) {
                String value = (String)signinParams.get("wreply");
                if (value != null) {
                    WebUtils.putAttributeInFlowScope((RequestContext)context, (String)"wreply", (Object)value);
                }
                if ((value = (String)signinParams.get("wtrealm")) != null) {
                    WebUtils.putAttributeInFlowScope((RequestContext)context, (String)"wtrealm", (Object)value);
                }
                if ((value = (String)signinParams.get("whr")) != null) {
                    WebUtils.putAttributeInFlowScope((RequestContext)context, (String)"whr", (Object)value);
                }
                LOG.debug("SignIn parameters restored: {}", (Object)signinParams.toString());
                WebUtils.removeAttributeFromFlowScope((RequestContext)context, (String)"wctx");
                LOG.info("SignIn parameters restored and wctx[" + uuidKey + "] cleared.");
                value = (String)signinParams.get("wctx");
                if (value != null) {
                    WebUtils.putAttributeInFlowScope((RequestContext)context, (String)"wctx", (Object)value);
                }
            } else {
                LOG.debug("Error in restoring security context");
            }
        } else {
            LOG.debug("Error in restoring security context");
        }
    }

    public void storeRPConfigInSession(RequestContext context) throws ProcessingException {
        String wtrealm = (String)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"wtrealm");
        Idp idpConfig = (Idp)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"idpConfig");
        if (wtrealm == null || idpConfig == null) {
            return;
        }
        Application serviceConfig = idpConfig.findApplication(wtrealm);
        if (serviceConfig != null) {
            HashMap<String, Application> realmConfigMap;
            if (serviceConfig.getPassiveRequestorEndpoint() == null) {
                String url = this.guessPassiveRequestorURL(context, wtrealm);
                serviceConfig.setPassiveRequestorEndpoint(url);
            }
            if ((realmConfigMap = (HashMap<String, Application>)WebUtils.getAttributeFromExternalContext((RequestContext)context, (String)ACTIVE_APPLICATIONS)) == null) {
                realmConfigMap = new HashMap<String, Application>();
                WebUtils.putAttributeInExternalContext((RequestContext)context, (String)ACTIVE_APPLICATIONS, realmConfigMap);
            }
            if (realmConfigMap.get(wtrealm) == null) {
                realmConfigMap.put(wtrealm, serviceConfig);
            }
        }
    }

    protected String guessPassiveRequestorURL(RequestContext context, String wtrealm) throws ProcessingException {
        String url = (String)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"wreply");
        try {
            new URL(url);
        }
        catch (Exception e) {
            url = null;
        }
        if (url == null) {
            url = wtrealm;
            try {
                new URL(url);
            }
            catch (Exception e) {
                throw new ProcessingException(e.getMessage(), (Throwable)e, ProcessingException.TYPE.INVALID_REQUEST);
            }
        }
        return url;
    }
}

