/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.beans;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.util.DOMUtils;
import org.apache.cxf.fediz.service.idp.IdpSTSClient;
import org.apache.cxf.fediz.service.idp.domain.Application;
import org.apache.cxf.fediz.service.idp.domain.Idp;
import org.apache.cxf.fediz.service.idp.domain.RequestClaim;
import org.apache.cxf.fediz.service.idp.util.WebUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.trust.STSClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class STSClientAction {
    private static final String HTTP_SCHEMAS_XMLSOAP_ORG_WS_2005_05_IDENTITY = "http://schemas.xmlsoap.org/ws/2005/05/identity";
    private static final String HTTP_DOCS_OASIS_OPEN_ORG_WS_SX_WS_TRUST_200512_BEARER = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer";
    private static final String HTTP_DOCS_OASIS_OPEN_ORG_WS_SX_WS_TRUST_200512_PUBLICKEY = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey";
    private static final String HTTP_WWW_W3_ORG_2005_08_ADDRESSING = "http://www.w3.org/2005/08/addressing";
    private static final String HTTP_DOCS_OASIS_OPEN_ORG_WS_SX_WS_TRUST_200512 = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/";
    private static final String HTTP_SCHEMAS_XMLSOAP_ORG_WS_2005_02_TRUST = "http://schemas.xmlsoap.org/ws/2005/02/trust";
    private static final String SECURITY_TOKEN_SERVICE = "SecurityTokenService";
    private static final Logger LOG = LoggerFactory.getLogger(STSClientAction.class);
    protected String namespace = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/";
    protected String wsdlLocation;
    protected String wsdlEndpoint;
    protected String wsdlService = "SecurityTokenService";
    protected String tokenType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0";
    protected boolean use200502Namespace;
    protected int ttl = 1800;
    protected Bus bus;
    private boolean isPortSet;
    private String keyType = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer";

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
        try {
            URL url = new URL(wsdlLocation);
            boolean bl = this.isPortSet = url.getPort() > 0;
            if (!this.isPortSet) {
                LOG.info("Port is 0 for 'wsdlLocation'. Port evaluated when processing first request.");
            }
        }
        catch (MalformedURLException e) {
            LOG.error("Invalid Url '" + wsdlLocation + "': " + e.getMessage());
        }
    }

    public String getWsdlEndpoint() {
        return this.wsdlEndpoint;
    }

    public void setWsdlEndpoint(String wsdlEndpoint) {
        this.wsdlEndpoint = wsdlEndpoint;
    }

    public String getWsdlService() {
        return this.wsdlService;
    }

    public void setWsdlService(String wsdlService) {
        this.wsdlService = wsdlService;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public Bus getBus() {
        return this.bus != null ? this.bus : BusFactory.getDefaultBus();
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public Element submit(RequestContext context, String realm, String homeRealm) throws Exception {
        HttpServletRequest servletRequest;
        SecurityToken idpToken = this.getSecurityToken(context, homeRealm);
        Bus cxfBus = this.getBus();
        Idp idpConfig = (Idp)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"idpConfig");
        IdpSTSClient sts = new IdpSTSClient(cxfBus);
        sts.setAddressingNamespace(HTTP_WWW_W3_ORG_2005_08_ADDRESSING);
        Application serviceConfig = idpConfig.findApplication(realm);
        if (serviceConfig == null) {
            LOG.warn("No service config found for " + realm);
            throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
        }
        String wreq = (String)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"wreq");
        String stsTokenType = null;
        String stsKeyType = this.keyType;
        if (wreq != null) {
            try {
                Document wreqDoc = DOMUtils.readXml((Reader)new StringReader(wreq));
                Element wreqElement = wreqDoc.getDocumentElement();
                if (wreqElement != null && "RequestSecurityToken".equals(wreqElement.getLocalName()) && ("http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(wreqElement.getNamespaceURI()) || HTTP_SCHEMAS_XMLSOAP_ORG_WS_2005_02_TRUST.equals(wreqElement.getNamespaceURI()))) {
                    Element keyTypeElement;
                    Element tokenTypeElement = DOMUtils.getFirstChildWithName((Element)wreqElement, (String)wreqElement.getNamespaceURI(), (String)"TokenType");
                    if (tokenTypeElement != null) {
                        stsTokenType = tokenTypeElement.getTextContent();
                    }
                    if ((keyTypeElement = DOMUtils.getFirstChildWithName((Element)wreqElement, (String)wreqElement.getNamespaceURI(), (String)"KeyType")) != null) {
                        stsKeyType = keyTypeElement.getTextContent();
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Error parsing 'wreq' parameter: " + e.getMessage());
                throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
            }
        }
        if (stsTokenType != null) {
            sts.setTokenType(stsTokenType);
        } else if (serviceConfig.getTokenType() != null && serviceConfig.getTokenType().length() > 0) {
            sts.setTokenType(serviceConfig.getTokenType());
        } else {
            sts.setTokenType(this.getTokenType());
        }
        if (serviceConfig.getPolicyNamespace() != null && serviceConfig.getPolicyNamespace().length() > 0) {
            sts.setWspNamespace(serviceConfig.getPolicyNamespace());
        }
        LOG.debug("TokenType {} set for realm {}", (Object)sts.getTokenType(), (Object)realm);
        sts.setKeyType(stsKeyType);
        if (HTTP_DOCS_OASIS_OPEN_ORG_WS_SX_WS_TRUST_200512_PUBLICKEY.equals(stsKeyType) && (servletRequest = WebUtils.getHttpServletRequest((RequestContext)context)) != null) {
            X509Certificate[] certs = (X509Certificate[])servletRequest.getAttribute("javax.servlet.request.X509Certificate");
            if (certs != null && certs.length > 0) {
                sts.setUseCertificateForConfirmationKeyInfo(true);
                sts.setUseKeyCertificate(certs[0]);
            } else {
                LOG.info("Can't send a PublicKey KeyType as no client certs are available");
                sts.setKeyType(HTTP_DOCS_OASIS_OPEN_ORG_WS_SX_WS_TRUST_200512_BEARER);
            }
        }
        this.processWsdlLocation(context);
        sts.setWsdlLocation(this.wsdlLocation);
        sts.setServiceQName(new QName(this.namespace, this.wsdlService));
        sts.setEndpointQName(new QName(this.namespace, this.wsdlEndpoint));
        if (this.use200502Namespace) {
            sts.setNamespace(HTTP_SCHEMAS_XMLSOAP_ORG_WS_2005_02_TRUST);
        }
        if (serviceConfig.getRequestedClaims() != null && serviceConfig.getRequestedClaims().size() > 0) {
            this.addClaims((STSClient)sts, serviceConfig.getRequestedClaims());
            LOG.debug("Requested claims set for {}", (Object)realm);
        }
        sts.setEnableLifetime(true);
        this.setLifetime((STSClient)sts, serviceConfig, realm);
        sts.setEnableAppliesTo(serviceConfig.isEnableAppliesTo());
        sts.setOnBehalfOf((Object)idpToken.getToken());
        if (serviceConfig.getProtocol() != null && !"http://docs.oasis-open.org/wsfed/federation/200706".equals(serviceConfig.getProtocol())) {
            LOG.error("Protocol {} not supported for realm {} ", (Object)serviceConfig.getProtocol(), (Object)realm);
            throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
        }
        Element rpToken = null;
        try {
            rpToken = sts.requestSecurityTokenResponse(realm);
        }
        catch (SoapFault ex) {
            LOG.error("Error in retrieving a token", (Object)ex.getMessage());
            if (ex.getFaultCode() != null && "RequestFailed".equals(ex.getFaultCode().getLocalPart())) {
                throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
            }
            throw ex;
        }
        if (LOG.isInfoEnabled()) {
            String id = this.getIdFromToken(rpToken);
            LOG.info("[RP_TOKEN={}] successfully created for realm [{}] on behalf of [IDP_TOKEN={}]", new Object[]{id, realm, idpToken.getId()});
        }
        return rpToken;
    }

    private String getIdFromToken(Element token) throws IOException, XMLStreamException {
        if (token != null) {
            Element e;
            NodeList nd = token.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
            String identifier = "ID";
            if (nd.getLength() == 0) {
                nd = token.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
                identifier = "AssertionID";
            }
            if (nd.getLength() > 0 && (e = (Element)nd.item(0)).hasAttributeNS(null, identifier)) {
                return e.getAttributeNS(null, identifier);
            }
        }
        return "";
    }

    private SecurityToken getSecurityToken(RequestContext context, String homeRealm) throws ProcessingException {
        SecurityToken idpToken = (SecurityToken)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"idpToken");
        if (idpToken == null) {
            LOG.error("IDP_TOKEN not found");
            throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
        }
        LOG.debug("[IDP_TOKEN={} successfully retrieved from cache for home realm [{}]", (Object)idpToken.getId(), (Object)homeRealm);
        return idpToken;
    }

    private void processWsdlLocation(RequestContext context) {
        if (!this.isPortSet) {
            try {
                URL url = new URL(this.wsdlLocation);
                URL updatedUrl = new URL(url.getProtocol(), url.getHost(), WebUtils.getHttpServletRequest((RequestContext)context).getLocalPort(), url.getFile());
                this.setSTSWsdlUrl(updatedUrl.toString());
                LOG.info("STS WSDL URL updated to {}", (Object)updatedUrl.toString());
            }
            catch (MalformedURLException e) {
                LOG.error("Invalid Url '{}': {}", (Object)this.wsdlLocation, (Object)e.getMessage());
            }
        }
    }

    private void addClaims(STSClient sts, List<RequestClaim> requestClaimList) throws ParserConfigurationException, XMLStreamException {
        Element claims = this.createClaimsElement(requestClaimList);
        if (claims != null) {
            sts.setClaims((Object)claims);
        }
    }

    private Element createClaimsElement(List<RequestClaim> realmClaims) throws ParserConfigurationException, XMLStreamException {
        if (realmClaims == null || realmClaims.size() == 0) {
            return null;
        }
        W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
        writer.writeStartElement("wst", "Claims", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        writer.writeNamespace("wst", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        writer.writeNamespace("ic", HTTP_SCHEMAS_XMLSOAP_ORG_WS_2005_05_IDENTITY);
        writer.writeAttribute("Dialect", HTTP_SCHEMAS_XMLSOAP_ORG_WS_2005_05_IDENTITY);
        if (realmClaims != null && realmClaims.size() > 0) {
            for (RequestClaim item : realmClaims) {
                LOG.debug("  {}", (Object)item.getClaimType().toString());
                writer.writeStartElement("ic", "ClaimType", HTTP_SCHEMAS_XMLSOAP_ORG_WS_2005_05_IDENTITY);
                writer.writeAttribute("Uri", item.getClaimType().toString());
                writer.writeAttribute("Optional", Boolean.toString(item.isOptional()));
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
        return writer.getDocument().getDocumentElement();
    }

    private synchronized void setSTSWsdlUrl(String wsdlUrl) {
        this.wsdlLocation = wsdlUrl;
        this.isPortSet = true;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public boolean isUse200502Namespace() {
        return this.use200502Namespace;
    }

    public void setUse200502Namespace(boolean use200502Namespace) {
        this.use200502Namespace = use200502Namespace;
    }

    private void setLifetime(STSClient sts, Application serviceConfig, String wtrealm) {
        if (serviceConfig.getLifeTime() > 0) {
            try {
                int lifetime = serviceConfig.getLifeTime();
                sts.setTtl(lifetime);
                sts.setEnableLifetime(lifetime > 0);
                LOG.debug("Lifetime set to {} seconds for realm {}", (Object)serviceConfig.getLifeTime(), (Object)wtrealm);
            }
            catch (NumberFormatException ex) {
                LOG.warn("Invalid lifetime configured for service provider " + wtrealm);
                sts.setTtl(this.ttl);
                sts.setEnableLifetime(this.ttl > 0);
            }
        } else {
            sts.setTtl(this.ttl);
            sts.setEnableLifetime(this.ttl > 0);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Lifetime set to {} seconds for realm {}", (Object)this.ttl, (Object)wtrealm);
            }
        }
    }
}

