/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.beans;

import javax.servlet.http.Cookie;
import org.apache.cxf.fediz.service.idp.beans.HomeRealmReminder;
import org.apache.cxf.fediz.service.idp.domain.Idp;
import org.apache.cxf.fediz.service.idp.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.stereotype.Component;
import org.springframework.webflow.execution.RequestContext;

@Component
public class ProcessHRDSExpressionAction {
    private static final String IDP_CONFIG = "idpConfig";
    private static final Logger LOG = LoggerFactory.getLogger(ProcessHRDSExpressionAction.class);
    @Autowired
    private HomeRealmReminder homeRealmReminder;

    public String submit(RequestContext context, String homeRealm) {
        Cookie homeRealmCookie = this.homeRealmReminder.readCookie(context);
        if (homeRealmCookie != null) {
            LOG.debug("Home Realm Cookie set: {}", (Object)homeRealmCookie);
            return homeRealmCookie.getValue();
        }
        Idp idpConfig = (Idp)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)IDP_CONFIG);
        String hrds = idpConfig.getHrds();
        if (hrds != null) {
            LOG.debug("HomeRealmDiscoveryService EL: {}", (Object)hrds);
            SpelExpressionParser parser = new SpelExpressionParser();
            Expression exp = parser.parseExpression(hrds);
            String result = (String)exp.getValue((Object)context, String.class);
            LOG.info("Realm resolved by HomeRealmDiscoveryService: {}", (Object)result);
            return result;
        }
        LOG.debug("No custom homeRealm handling, using home realm parameter as provided in request: {}", (Object)homeRealm);
        return homeRealm;
    }
}

