/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.idp.beans;

import java.util.regex.Matcher;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.cxf.fediz.service.idp.domain.Application;
import org.apache.cxf.fediz.service.idp.domain.Idp;
import org.apache.cxf.fediz.service.idp.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.webflow.execution.RequestContext;

@Component
public class PassiveRequestorValidator {
    private static final Logger LOG = LoggerFactory.getLogger(PassiveRequestorValidator.class);

    public boolean isValid(RequestContext context, String endpointAddress, String realm) throws Exception {
        if (endpointAddress == null) {
            return true;
        }
        Idp idpConfig = (Idp)WebUtils.getAttributeFromFlowScope((RequestContext)context, (String)"idpConfig");
        Application serviceConfig = idpConfig.findApplication(realm);
        if (serviceConfig == null) {
            LOG.warn("No service config found for " + realm);
            return true;
        }
        UrlValidator urlValidator = new UrlValidator(9L);
        if (!urlValidator.isValid(endpointAddress)) {
            LOG.warn("The given endpointAddress parameter {} is not a valid URL", (Object)endpointAddress);
            return false;
        }
        if (serviceConfig.getCompiledPassiveRequestorEndpointConstraint() == null) {
            LOG.warn("No passive requestor endpoint constraint is configured for the application. This could lead to a malicious redirection attack");
            return true;
        }
        Matcher matcher = serviceConfig.getCompiledPassiveRequestorEndpointConstraint().matcher(endpointAddress);
        if (!matcher.matches()) {
            LOG.error("The endpointAddress value of {} does not match any of the passive requestor values", (Object)endpointAddress);
            return false;
        }
        return true;
    }
}

